#' Functional trait data for species in serpentine grassland
#'
#' A dataset containing two traits for species in a serpentine grassland.
#' The variables are as follows:
#'
#' \itemize{
#'   \item species. species name
#'   \item wue. average water use efficiency, rate of carbon assimilation per unit of water used
#'   \item rootdepth. average rooting depth in soil
#' }
#'
#' @docType data
#' @keywords datasets
#' @name serpentine
#' @format dataframe of 48 species and 2 traits
#' @usage data(serpentine)
#' @source Funk, J.L. & Wolf, A.A. 2016. Testing the trait based community framework: Do functional traits predict competitive outcomes? Ecology 97:2206-2211.
#'
"serpentine"
