#' Functional trait data for understory species in ponderosa pine forest
#'
#' A dataset containing two traits for species in a pine forest.
#' The variables are as follows:
#'
#' \itemize{
#'   \item species. species name
#'   \item flrdate. average flowering date in day of year
#'   \item leafcn. average leaf carbon-to-nitrogen ratio
#' }
#'
#' @docType data
#' @keywords datasets
#' @name pineforest
#' @format dataframe of 46 species and 2 traits
#' @usage data(pineforest)
#' @source Laughlin, D.C., J.J. Leppert, M.M. Moore, and C.H. Sieg. 2010. A multi-trait test of the leaf-height-seed plant strategy scheme with 133 species from a pine forest flora. Functional Ecology 24:493-501.
#'
"pineforest"
