% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transform.R
\encoding{UTF-8}
\name{Transform}
\alias{Destring}
\alias{Factorize}
\alias{Safechars}
\alias{Transform}
\title{Functions for transformation of variables.}
\usage{
Factorize(.data, vars)

Destring(.data, vars)

Safechars(.data)
}
\arguments{
\item{.data}{data.table or data.frame object.}

\item{vars}{Character or vector of characters with variables names to transform.}

\item{.data}{a \code{data.frame}.}
}
\value{
Data.table object with transformed variables.
}
\description{
Functions for transformation of variables.

By default, R converts character columns to factors.
Instead of re-reading the data using \code{stringsAsFactors}, the
\code{\link{Safechars}} function will identify which columns are currently factors, and convert them all to characters.
}
\examples{
Factorize(mtcars, c("cyl", "mpg"))
 str(iris)
iris_2 = Safechars(iris)
str(iris_2)

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\seealso{
\code{\link{read.table}}, \code{\link{Destring}}.
}
\keyword{internal}

