% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DATA.R
\docType{data}
\encoding{UTF-8}
\name{words}
\alias{words}
\title{Word frequencies from Mosteller and Wallace}
\format{A \code{data.frame} object with \Sexpr[stage=build,results=rd]{ncol(SciencesPo::words)} variables and \Sexpr[stage=build,results=rd]{nrow(SciencesPo::words)} observations.}
\source{
Mosteller, F. and Wallace, D. (1964). Inference and Disputed Authorship: The Federalist. Reading, MA: Addison-Wesley.
}
\usage{
data(words)
}
\description{
The data give the frequencies of words in works from four different sources: the political writings of eighteenth century American political figures Alexander Hamilton, James Madison, and John Jay, and the book Ulysses by twentieth century Irish writer James Joyce. This dataset contains the following columns:

\itemize{
\item Hamilton Hamilton frequency.
\item HamiltonRank Hamilton rank.
\item Madison Madison frequency.
\item MadisonRank Madison rank.
\item Jay Jay frequency.
\item JayRank Jay rank.
\item Ulysses Word frequency in Ulysses.
\item UlyssesRank Word rank in Ulysses.
 }

 @references Weisberg, S. (2014). Applied Linear Regression, 4th edition. Hoboken NJ: Wiley.
}
\keyword{datasets}

