% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Describe.R
\encoding{UTF-8}
\name{Describe}
\alias{Describe}
\alias{Detail}
\title{Summary Description Table}
\usage{
Describe(.data, style = "multiline", justify = "left", max.number = 10,
  trim.strings = FALSE, max.width = 15, digits = 2, split.cells = 35,
  display.labels = FALSE, display.attributes = FALSE, file = NA,
  append = FALSE, escape.pipe = FALSE, ...)
}
\arguments{
\item{.data}{a data frame.}

\item{style}{the style to be used in pander table, one of \dQuote{multiline},
\dQuote{grid}, \dQuote{simple}, and \dQuote{rmarkdown}.}

\item{justify}{\pkg{pander} argument; defaults is justified to \dQuote{left}.}

\item{max.number}{an integer for the maximum number of items to be displayed in the frequency cell. If variable has more distinct values, no frequency will be shown (only a message stating the number of distinct values).}

\item{trim.strings}{remove white spaces at the beginning or end of the string. This may impact the frequencies, so interpret the frequencies cell accordingly. Defaults to \code{FALSE}.}

\item{max.width}{Limits the number of characters to display in the frequency tables. Defaults to \code{15}.}

\item{digits}{the number of digits for rounding.}

\item{split.cells}{\pkg{pander} argument. Number of characters allowed on a
line before splitting the cell. Defaults to 35.}

\item{display.labels}{If \code{TRUE}, variable labels will be displayed. Defaults to \code{FALSE}.}

\item{display.attributes}{If \code{TRUE}, variable attibutes will be displayed. Defaults to \code{FALSE}.}

\item{file}{the text file to be written to disk. Defaults to \code{NA}.}

\item{append}{When \dQuote{file} argument is supplied, this indicates whether to append output to existing file (\code{TRUE}) or to overwrite any existing file (\code{FALSE}, default). If \code{TRUE} and no file exists, a new file will be created.}

\item{escape.pipe}{Only useful when \code{style='grid'} and \code{file} argument is not \code{NA}, in which case it will escape the pipe character (|) to allow Pandoc to correctly convert multiline cells.}

\item{\dots}{additional arguments passed to \pkg{pander}.}
}
\description{
Produce summary description table of a dataframe with the following features:
variable names, labels, factor levels, frequencies or summary statistics.
}
\details{
The IQR formula used is the R standard \code{IQR(x) = quantile(x, 3/4) - quantile(x, 1/4)}. The (CV) stands for the
coefficient of variation also known as relative standard deviation (RSD),
defined as the ratio of the standard deviation
to the mean.
}
\examples{
data(religiosity)
Describe(religiosity)

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Exploratory}

