% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{anscombe.glynn}
\alias{anscombe.glynn}
\title{Anscombe-Glynn test of kurtosis}
\usage{
anscombe.glynn(x, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{x}{A numeric vector of data values.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of '"two.sided"' (default), '"greater"' or '"less"'. You can
 specify just the initial letter.}
}
\description{
Performs the Anscombe-Glynn test of kurtosis for normal samples.
}
\details{
Under the hypothesis of normality, data should have kurtosis equal
 to 3.This test has such null hypothesis and is useful to detect a
 significant difference of kurtosis in normally distributed data.
}
\examples{
set.seed(1234)
x = rnorm(1000)
kurtosis(x)
anscombe.glynn(x)
}
\references{
Anscombe, F.J., Glynn, W.J. (1983) Distribution of kurtosis
statistic for normal statistics. Biometrika, 70, 1, 227-234
}

