% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Map_Invalsi.R
\name{Map_Invalsi}
\alias{Map_Invalsi}
\title{Display a map of Invalsi scores}
\usage{
Map_Invalsi(
  data = NULL,
  Year = 2023,
  subj_toplot = "ITA",
  grade = 8,
  level = "LAU",
  main = "",
  main_pos = "top",
  region_code = c(1:20),
  plot = "mapview",
  pal = "Blues",
  WLE = FALSE,
  col_rev = FALSE,
  popup_height = 200,
  verbose = TRUE,
  input_shp = NULL,
  autoAbort = FALSE
)
}
\arguments{
\item{data}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
The raw Invalsi survey data that has to be filtered, obtained as output of the \code{\link{Get_Invalsi_IS}} function.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default}

\item{Year}{Numeric or character value. Reference school year for the data (last available is 2022/23).
Available in the formats: \code{2022}, \code{"2021/2022"}, \code{202122}, \code{20212022}. \code{2022} by default}

\item{subj_toplot}{Character. The school subject to display in the map,
The school subject to include, one among:
\code{"Englis_listening"}/\code{"ELI"}, \code{"English_reading"}/\code{"ERE"}, \code{"Italian"}/\code{"ITA"} and \code{"Mathematics"}/\code{"MAT"}. \code{"ITA"} (Italian) by default.}

\item{grade}{Numeric. The school grade to chose. Either \code{2} (2nd year of primary school), \code{5} (last year of primary school), \code{8} (last year of middle shcool), \code{10} (2nd year of high school) or \code{13} (last year of school). \code{8} by default}

\item{level}{Character. The level of aggregation of Invalsi census data. Either \code{"NUTS-3"}, \code{"Province"}, \code{"LAU"}, \code{"Municipality"}.
If an input dataframe is provided, please select the same level of aggregation.
\code{"LAU"} by default}

\item{main}{Character. A customary title to the map. If \code{NULL}, the title will mention: subject, year and school grade. Empty by default.}

\item{main_pos}{Character.Where the header should be placed if the \code{ggplot} mode is chosen.
The header is located on the top if \code{"top"} is given as input, and above the legend scale otherwise. \code{"top"} by default.}

\item{region_code}{Numeric. The NUTS-2 codes of the units that must be displayed.
If the level is set to \code{"LAU"}, choosing a limited number of regions is recommended.
By default, \code{c(1,3,5:20)}, i.e. all Italian regions except the provinces of Aosta, Trento and Bozen which have data availability issues.}

\item{plot}{Character. The type of map to display; either \code{"mapview"} for interactive maps, or \code{"ggplot"} for static maps. \code{"mapview"} by default.}

\item{pal}{Character. The palette to use if the \code{"mapview"} mode is chose. \code{"Blues"} by default.}

\item{WLE}{Logical. Whether the variable to chose should be the average WLE score rather that the percentage of sufficient tests, if both are available. \code{FALSE} by default}

\item{col_rev}{Logical. Whether the scale of the colour palette should be reverted or not, if the \code{mapview} mode is chosen. \code{FALSE} by default}

\item{popup_height}{Numeric. The height of the popup table in terms of pixels if the \code{"mapview"} mode is chosen. \code{200} by default.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{input_shp}{Object of class \code{sf}, \code{tbl_df}, \code{tbl}, \code{data.frame}. The relevant shapefiles of Italian administrative boudaries,
at the selected level of detail (LAU or NUTS-3). If \code{NULL}, it is downloaded automatically but not saved in the global environment. \code{NULL} by default.}

\item{autoAbort}{Logical. In case any data must be retrieved, whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}
}
\value{
If \code{plot == "mapview"}, an object of class \code{mapview}. Otherwise, if \code{plot == "ggplot"}, an object of class \code{gg} and \code{ggplot}.
}
\description{
This function displays either a static or interactive map of the Invalsi scores, either at the municipality or province level.
It supports two kinds of map:
\itemize{
  \item Interactive map (default option), which allows the user to visualize all the data in scope through the interactive popup, and
  \item Static map (ggplot), which can be easily exported in \code{.pdf} objects.
}
}
\examples{




 Map_Invalsi(subj = "Italian", grade = 13, level = "NUTS-3", Year = 2023, WLE = FALSE,
  data = example_Invalsi23_prov, input_shp = example_Prov22_shp, plot = "ggplot")

 Map_Invalsi(subj = "Italian", grade = 5, level = "NUTS-3", Year = 2023, WLE = TRUE,
  data = example_Invalsi23_prov, input_shp = example_Prov22_shp, plot = "ggplot")





}
