% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Map_DB.R
\name{Map_DB}
\alias{Map_DB}
\title{Map school data}
\usage{
Map_DB(
  data = NULL,
  Year = 2023,
  field,
  level = "LAU",
  plot = "mapview",
  popup_height = 200,
  col_rev = FALSE,
  pal = "Blues",
  input_shp = NULL,
  region_code = c(1:20),
  main_pos = "top",
  main = "",
  order = NULL,
  autoAbort = FALSE,
  ...
)
}
\arguments{
\item{data}{Object of class \code{tbl.df}, \code{tbl} and \code{data.frame}, obtained as output of the \code{\link{Set_DB}} function. If NULL, it will be arranged automatically but not saved into the global environment. NULL by default.}

\item{Year}{Numeric or Character. The reference school year, needed if either \code{data} or \code{input_shp} are not provided.
Available in the formats: \code{2023}, \code{"2022/2023"}, \code{202223}, \code{20222023}.  \code{2023} by default.}

\item{field}{Character. The variable to display in the map.}

\item{level}{Character. The administrative level of detailed at which the target variable must be displayed. Either \code{"LAU"}/\code{"Municipality"} or \code{"NUTS-3"}/\code{"Province"}. If the \code{"data"} argument is plugged in, please select the same level. \code{"LAU"} by default.}

\item{plot}{Character. The type of map to display; either \code{"mapview"} for interactive maps, or \code{"ggplot"} for static maps. \code{"mapview"} by default.}

\item{popup_height}{Numeric. The height of the popup table in terms of pixels if the \code{"mapview"} mode is chosen. \code{200} by default.}

\item{col_rev}{Logical. Whether the scale of the colour palette should be reverted or not. \code{FALSE} by default.}

\item{pal}{Character. The palette to use if the \code{"mapview"} mode is chose. \code{"Blues"} by default.}

\item{input_shp}{Object of class \code{sf}, \code{tbl.df}, \code{tbl} and \code{data.frame}. The relevant shapefiles of Italian administrative boundaries,
at the selected level of detail (LAU or NUTS-3). If \code{NULL}, it is downloaded automatically but not saved in the global environment. \code{NULL} by default.}

\item{region_code}{Numeric. The NUTS-2 codes of the units that must be displayed.
If the level is set to \code{"LAU"}, choosing a limited number of regions is recommended.
By default, \code{c(1,3,5:20)}, i.e. all Italian regions except the provinces of Aosta, Trento and Bozen which have data availability issues.}

\item{main_pos}{Character.Where the header should be placed if the \code{ggplot} mode is chosen.
The header is located on the top if \code{"top"} is given as input, and above the legend scale otherwise. \code{"top"} by default.}

\item{main}{Character. The title to display in the \code{"ggplot"} rendering options.}

\item{order}{Character. The educational level. Either \code{"Primary"} (primary school), \code{"Middle"} (middle school), or \code{"High"} (high school).
If the data include the Invalsi census survey, please select a level consistent with the chosen educational grade. \code{"Media"} by default.}

\item{autoAbort}{Logical. In case any data must be retrieved, whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}

\item{...}{Additional arguments for the input database, if not provided; see \code{\link{Set_DB}}}
}
\value{
If \code{plot == "mapview"}, an object of class \code{mapview}. Otherwise, if \code{plot == "ggplot"}, an object of class \code{gg} and \code{ggplot}.
}
\description{
This function displays a map of the data arranged trough the function \code{\link{Set_DB}}.
It supports two kinds of map:
\itemize{
  \item Interactive map (default option), which allows the user to visualize all the data in scope through the interactive popup, and
  \item Static map (ggplot), which can be easily exported in \code{.pdf} objects.
}


The user must select a variable to display.
It is possible to insert either a readily-downloaded database obtained through the function \code{\link{Set_DB}} or the basic inputs to plug in that function, other than an input shapefile. Relevant arguments not provided by the user will be download automatically, but not saved into the global environment. However we suggest to plug in at least some inputs, as otherwise the running time may be long.
This function generalises the functionalities of the more data-specific functions \code{\link{Map_School_Buildings}} and \code{\link{Map_Invalsi}}.
}
\examples{



DB23 <- Set_DB(Year = 2023, level = "NUTS-3",
       Invalsi_grade = c(10,13), NA_autoRM = TRUE,
       input_Invalsi_IS = example_Invalsi23_prov, input_nstud = example_input_nstud23,
       input_InnerAreas = example_InnerAreas,
       input_School2mun = example_School2mun23,
       input_AdmUnNames = example_AdmUnNames20220630,
       nteachers = FALSE, BroadBand = FALSE, SchoolBuildings = FALSE)




Map_DB(DB23, field = "Students_per_class_13", input_shp = example_Prov22_shp, level = "NUTS-3",
 col_rev = TRUE, plot = "ggplot")

Map_DB(DB23, field = "Inner_area", input_shp = example_Prov22_shp, order = "High",
 level = "NUTS-3",col_rev = TRUE, plot = "ggplot")

Map_DB(DB23, field = "M_Mathematics_10", input_shp = example_Prov22_shp, level = "NUTS-3",
 plot = "ggplot")


}
