# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title
#' buildAstar
#' @description
#' Builds the A* matrix
#' 
#' @param foinew numeric \code{\link[base]{matrix}} representing the file of interest
#' 
#' @param ldfnew numeric \code{\link[base]{matrix}} representing the linking data file
#'
#' @param grainsize integer determining minimum grain size for parallisation
#'
#' @param debug Boolean indicating whether to output additional debugging information
#' 
#' @details
#' \code{buildAstar} takes a matrix representing the file of interest and 
#' a matrix representing the linking data file and creates a matrix that 
#' can then be used to generating linking scores. Reporting frequency as this
#' occurs can be specified via the nreport option. This is implemented in C++
#' to provide a speed increase over implementing it directly in the R equivalent.
#' @export
buildAstar <- function(foinew, ldfnew, grainsize, debug) {
    .Call('_Scalelink_buildAstar', PACKAGE = 'Scalelink', foinew, ldfnew, grainsize, debug)
}

