% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condorcet.R
\name{condorcet}
\alias{condorcet}
\title{Count votes using the Condorcet voting method.}
\usage{
condorcet(
  votes,
  runoff = FALSE,
  nseats = 1,
  safety = 1,
  fsep = "\\t",
  quiet = FALSE,
  ...
)
}
\arguments{
\item{votes}{A \link{matrix} or \link{data.frame} containing the votes. Rows correspond
to the votes, columns correspond to the candidates. If \code{votes} is a
character string, it is interpreted as a file name from which the votes are
to be read. See
\href{https://cthombor.github.io/SafeVote/reference/condorcet#details}{below}.}

\item{runoff}{Logical. If \link{TRUE} and no Condorcet winner exists, the election
goes into a run-off, see
\href{https://cthombor.github.io/SafeVote/reference/condorcet#details}{below}.}

\item{nseats}{the number of seats to be filled in this election}

\item{safety}{Parameter for a clustering heuristic on a total ranking of
the candidates.  Conjecture: the default of \code{1.0} ensures a separation
of one s.d. between clusters, when \code{votes} are i.u.d. permutations on the
candidates.}

\item{fsep}{If \code{votes} is a file name, this argument gives the column
separator in the file.}

\item{quiet}{If \link{TRUE} no output is printed.}

\item{...}{Undocumented intent (preserved from legacy code)}
}
\value{
Object of class \code{SafeVote.condorcet}
}
\description{
The Condorcet method elects the candidate who wins a majority of the ranked
vote in every head to head election against each of the other candidates.
A Condorcet winner is a candidate who beats all other candidates
in pairwise comparisons. Analogously, a Condorcet loser is a candidate
who loses against all other candidates. Neither Condorcet winner nor loser
might exist.
}
\details{
If the runoff argument is set to \code{TRUE} and no Condorcet winner exists,
two or more candidates with the most pairwise wins are selected and
the method is applied to such subset. If more than two candidates are in
such run-off, the selection is performed repeatedly, until either a winner
is selected or no more selection is possible.

The input data votes is structured the same way as for the \link{stv} method:
Row \code{i} contains the preferences of voter \code{i} numbered
\verb{1; 2; : : : ; r; 0; 0; 0; 0}, in some order, while equal preferences
are allowed. The columns correspond to the candidates. The \link{dimnames} of
the columns are the names of the candidates; if these are not supplied
then the candidates are lettered \verb{A, B, C, ...}. If the dataset
contains missing values (\link{NA}), they are replaced by zeros.

If a ballot has equally-ranked candidates, its rankings are tested for
validity: for each preference \eqn{i} which does not have any duplicate,
there are exactly \eqn{i - 1} preferences \eqn{j} with \eqn{0 < j < i}. If
any ballot \code{x} fails this validity test, it is automatically corrected (aka
"converted") into a valid ballot using \code{x <- rank(x, ties.method = "min")},
and a warning is issued.

This method also computes a Borda ranking of all candidates, using
tournament-style scoring.  This ranking is "fuzzed" into a \code{safeRank}, with
approximately 1 s.d. of fuzz when \code{safety=1.0} and voter preferences are
i.u.d.  A warning is thrown if a \code{safeRank} violates the (extended) Condorcet
principle: that Candidate \eqn{i} is more highly ranked than Candidate
\eqn{j} only if a majority of voters agree with this.
}
\examples{
{
data(food_election)
condorcet(food_election)
}
}
