% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res_sk_map.R
\name{res_sk_map}
\alias{res_sk_map}
\title{Local Reserve Map With Seasonal Kendall Results}
\usage{
res_sk_map(
  nerr_site_id,
  stations,
  sk_result = NULL,
  bbox,
  shp,
  station_labs = TRUE,
  lab_loc = NULL,
  scale_pos = "bottomleft"
)
}
\arguments{
\item{nerr_site_id}{chr string of the reserve to make, first three characters used by NERRS}

\item{stations}{chr string of the reserve stations to include in the map}

\item{sk_result}{vector of values denoting direction and significance of seasonal kendall results. Result should be \code{c('inc', 'dec', 'insig', 'insuff')} for significant positive, significant negative, no significant results, and insufficient data to calculate result.}

\item{bbox}{a bounding box associated with the reserve. Must be in the format of c(X1, Y1, X2, Y2)}

\item{shp}{SpatialPolygons object}

\item{station_labs}{logical, should stations be labeled? Defaults to \code{TRUE}}

\item{lab_loc}{chr vector of 'R' and 'L', one letter for each station. if no \code{lab_loc} is specified then labels will default to the left.}

\item{scale_pos}{scale_pos where should the scale be placed? Options are 'topleft', 'topright', 'bottomleft', or 'bottomright'. Defaults to 'bottomleft'}
}
\value{
returns a leaflet object. This function is intended to be used with mapshot to generate a png
for the reserve level report
}
\description{
Create a stylized reserve-level map of seasonal kendall results for use with the reserve level reporting template
}
\details{
Creates a stylized, reserve-level base map for displaying seasonal kendall results from \code{\link{sk_seasonal}}. The user can specify the reserve and stations to plot. The user can also specify a bounding box. For multi-component reserves, the user should specify a bounding box that highlights the component of interest.

To display seasonal trends, the user must specify \code{c('inc', 'dec', 'insig')} for each station listed in the \code{stations} argument.
}
\examples{
## a compact reserve
### set plotting parameters
stations <-
sampling_stations[(sampling_stations$NERR.Site.ID == 'elk'
& sampling_stations$Status == 'Active' & sampling_stations$isSWMP == "P"), ]$Station.Code
to_match <- c('wq')
stns <- stations[grep(paste(to_match, collapse = '|'), stations)]
shp_fl <- elk_spatial
bounding_elk <- c(-121.810978, 36.868218, -121.708667, 36.764050)
pos <- 'bottomleft'
sk_res <- c('inc', 'dec', 'dec', 'insig')

### plot
res_sk_map('elk', stations = stns, sk_result = sk_res,
bbox = bounding_elk, scale_pos = pos, shp = shp_fl)

\donttest{
## a multicomponent reserve (showing two different bounding boxes)
### set plotting parameters
stations <-
sampling_stations[(sampling_stations$NERR.Site.ID == 'cbm'
& sampling_stations$Status == 'Active' & sampling_stations$isSWMP == "P"), ]$Station.Code
to_match <- c('wq')
stns <- stations[grep(paste(to_match, collapse = '|'), stations)]
shp_fl <- cbm_spatial
bounding_cbm_1 <- c(-77.393, 39.741, -75.553, 38.277)
bounding_cbm_2 <- c(-76.862006, 38.811571, -76.596508, 38.642454)
pos <- 'bottomleft'
sk_res <- c('inc', 'dec', 'dec', 'insig')

### plot
res_sk_map('cbm', stations = stns, sk_result = sk_res, bbox = bounding_cbm_1,
scale_pos = pos, shp = shp_fl)

res_sk_map('cbm', stations = stns, sk_result = sk_res, bbox = bounding_cbm_2,
scale_pos = pos, shp = shp_fl)

}

}
\author{
Julie Padilla
}
\concept{analyze}
