% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_misc.R
\name{oxySol}
\alias{oxySol}
\title{Dissolved oxygen at saturation}
\usage{
oxySol(t, S, P = NULL)
}
\arguments{
\item{t}{numeric for temperature, degrees C}

\item{S}{numeric for salinity, on the Practical Salinity Scale}

\item{P}{numeric for pressure, atm}
}
\value{
Dissolved oxygen concentration in mg/L at 100\% saturation. If \code{P = NULL}, saturation values at 1 atm are calculated.
}
\description{
Finds dissolved oxygen concentration in equilibrium with water-saturated air. Function and documentation herein are from archived wq package.
}
\details{
Calculations are based on the approach of Benson and Krause (1984), using Green and Carritt's (1967) equation for dependence of water vapor partial pressure on \code{t} and \code{S}. Equations are valid for temperature in the range 0-40 C and salinity in the range 0-40.
}
\references{
Benson, B.B. and Krause, D. (1984) The concentration and isotopic fractionation of oxygen dissolved in fresh-water and seawater in equilibrium with the atmosphere. \emph{Limnology and Oceanography} \bold{29,} 620-632.

Green, E.J. and Carritt, D.E. (1967) New tables for oxygen saturation of seawater. \emph{Journal of Marine Research} \bold{25,} 140-147.
}
