% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitINLA2.R
\name{fitINLA2}
\alias{fitINLA2}
\title{Fit cluster-level space-time smoothing models to mortality rates}
\usage{
fitINLA2(data, family = c("betabinomial", "binomial")[1],
  age.groups = c("0", "1-11", "12-23", "24-35", "36-47", "48-59"),
  age.n = c(1, 11, 12, 12, 12, 12), age.rw.group = 1:6, Amat, geo,
  bias.adj = NULL, bias.adj.by = NULL, formula = NULL, rw = 2,
  year_label, priors = NULL, type.st = 1, hyper = c("pc",
  "gamma")[1], pc.u = 1, pc.alpha = 0.01, pc.u.phi = 0.5,
  pc.alpha.phi = 2/3, a.iid = NULL, b.iid = NULL, a.rw = NULL,
  b.rw = NULL, a.icar = NULL, b.icar = NULL, options = list(config
  = TRUE), verbose = FALSE)
}
\arguments{
\item{data}{count data of person-months with the following columns
\itemize{
 \item cluster: cluster ID
 \item years: time period
 \item region: region of the cluster
\item strata: stratum of the cluster
\item age: age group corresponding to the row
\item total: total number of person-month in this age group, stratum, cluster, and period
\item Y: total number of deaths in this age group, stratum, cluster, and period
}}

\item{family}{family of the model. This can be either binomial (with logistic normal prior) or betabiniomial.}

\item{age.groups}{a character vector of age groups in increasing order.}

\item{age.n}{number of months in each age groups in the same order.}

\item{age.rw.group}{vector indicating grouping of the ages groups. For example, if each age group is assigned a different random walk component, then set age.rw.group to c(1:length(age.groups)); if all age groups share the same random walk component, then set age.rw.group to a rep(1, length(age.groups)). The default for 6 age groups is c(1,2,3,3,3,3), which assigns a separate random walk to the first two groups and a common random walk for the rest of the age groups. The vector should contain values starting from 1.}

\item{Amat}{Adjacency matrix for the regions}

\item{geo}{Geo file}

\item{bias.adj}{the ratio of unadjusted mortality rates or age-group-specific hazards to the true rates or hazards. It needs to be a data frame that can be merged to thee outcome, i.e., with the same column names for time periods (for national adjustment), or time periods and region (for subnational adjustment). The column specifying the adjustment ratio should be named "ratio".}

\item{bias.adj.by}{vector of the column names specifying how to merge the bias adjustment to the count data. For example, if bias adjustment factor is provided in bias.adj for each region and time, then bias.adj.by should be `c("region", "time")`.}

\item{formula}{INLA formula.  See vignette for example of using customized formula.}

\item{rw}{Take values 1 or 2, indicating the order of random walk.}

\item{year_label}{string vector of year names}

\item{priors}{priors from \code{\link{simhyper}}}

\item{type.st}{type for space-time interaction}

\item{hyper}{which hyperpriors to use. Default to be using the PC prior ("pc").}

\item{pc.u}{hyperparameter U for the PC prior on precisions.}

\item{pc.alpha}{hyperparameter alpha for the PC prior on precisions.}

\item{pc.u.phi}{hyperparameter U for the PC prior on the mixture probability phi in BYM2 model.}

\item{pc.alpha.phi}{hyperparameter alpha for the PC prior on the mixture probability phi in BYM2 model.}

\item{a.iid}{hyperparameter for i.i.d random effects.}

\item{b.iid}{hyperparameter for i.i.d random effects.}

\item{a.rw}{hyperparameter for RW 1 or 2 random effects.}

\item{b.rw}{hyperparameter for RW 1 or 2random effects.}

\item{a.icar}{hyperparameter for ICAR random effects.}

\item{b.icar}{hyperparameter for ICAR random effects.}

\item{options}{list of options to be passed to control.compute() in the inla() function.}

\item{verbose}{logical indicator to print out detailed inla() intermediate steps.}
}
\value{
INLA model fit using the provided formula, country summary data, and geographic data
}
\description{
Fit cluster-level space-time smoothing models to mortality rates
}
\examples{
message("Please check the package vignette on binomial models.")

}
\seealso{
\code{\link{getDirect}}
}
