% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateSurvey.R
\name{aggregateSurvey}
\alias{aggregateSurvey}
\title{Aggregate estimators from different surveys.}
\usage{
aggregateSurvey(data)
}
\arguments{
\item{data}{Output from \code{\link{getDirectList}}}
}
\value{
Estimators aggregated across surveys.
}
\description{
Aggregate estimators from different surveys.
}
\examples{
\dontrun{
data(DemoData)
data(DemoMap)
years <- levels(DemoData[[1]]$time)

# obtain direct estimates
data <- getDirectList(births = DemoData, 
years = years, 
regionVar = "region", timeVar = "time", 
clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", 
geo.recode = NULL)

# obtain maps
geo <- DemoMap$geo
mat <- DemoMap$Amat

# Simulate hyper priors
priors <- simhyper(R = 2, nsamp = 1e+05, nsamp.check = 5000, Amat = mat, only.iid = TRUE)

# combine data from multiple surveys
data <- aggregateSurvey(data)
utils::head(data)

}

}
