% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapPlot.R
\name{mapPlot}
\alias{mapPlot}
\title{Makes map plot.}
\usage{
mapPlot(countryname, results, geo, countrysum, inlamod)
}
\arguments{
\item{countryname}{Country name as a string}

\item{results}{output from \code{\link{projINLA}}}

\item{geo}{\code{geo} output from \code{\link{read_shape}}}

\item{countrysum}{output from \code{\link{countrySummary_mult}}}

\item{inlamod}{output from \code{\link{fitINLA}}}
}
\description{
Makes map plot.
}
\examples{
\dontrun{
data(Uganda)
data(UgandaMap)
geo <- UgandaMap$geo
mat <- UgandaMap$Amat
years <- c("85-89", "90-94", "95-99", "00-04", "05-09", "10-14")

# Get direct estimates
u5m <- countrySummary_mult(births = Uganda, years = years, idVar = "id", 
regionVar = "region", timeVar = "time", clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", geo.recode = NULL)

# Get hyper priors
priors <- simhyper(R = 2, nsamp = 1e+05, nsamp.check = 5000, Amat = mat)

# Fit INLA models
data <- data[data$region \%in\% c("central","eastern","northern","western"),]
inla_model <- fitINLA(data = data, geo = geo, Amat = mat, year_names = years, priors = priors)

# Projection
surveylabel <- paste0("DHS ", unique(data$surveyYears)) 
results_rw2 <- projINLA(data = data, inla_mod = inla_model, years = years, geo = geo, 
                     newyear = "15-19", quantiles = c(0.025,0.5,0.975))

# Plot results
mapPlot(countryname = "Uganda", results = results_rw2, geo = geo, 
countrysum = data, inlamod = inla_model)
}
}
