% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MedianPolishM.R
\name{plot.MedianPolishM}
\alias{plot.MedianPolishM}
\title{Plot Median polish multidimensional.}
\usage{
\method{plot}{MedianPolishM}(x, ...)
}
\arguments{
\item{x}{object of class MedianPolishM.}

\item{\dots}{ignored.}
}
\description{
Plot the effects of an additive model for multidimensional array, using Tukey's median polish procedure.
}
\details{
The object of class MedianPolish has a list of the contributions of every effect over data. The graphic shows for each iteration, the behavior of these components. If the median polish is applied to data of class ConstructutMPst, this method has a specific graphic for data with space - time variability.
}
\examples{
A<-MedianPolishM(UCBAdmissions, eps=0.1, maxiter=2, na.rm=TRUE)
plot(A)
}
\references{
Martínez, W. A., Melo, C. E., & Melo, O. O. (2017). \emph{Median Polish Kriging for space--time analysis of precipitation} Spatial Statistics, 19, 1-20. \href{http://www.sciencedirect.com/science/article/pii/S2211675316301336}{[link]}

Hoaglin, D. C., Mosteller, F., & Tukey, J. W. (Eds.). (2011). \emph{Exploring data tables, trends, and shapes} (Vol. 101). John Wiley & Sons.\href{http://www.wiley.com/WileyCDA/WileyTitle/productCd-047004005X.html}{[link]}
}
