% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearTSVM.R
\name{LinearTSVMSSLR}
\alias{LinearTSVMSSLR}
\title{General Interface for LinearTSVM model}
\usage{
LinearTSVMSSLR(
  C = 1,
  Cstar = 0.1,
  s = 0,
  x_center = FALSE,
  scale = FALSE,
  eps = 1e-06,
  verbose = FALSE,
  init = NULL
)
}
\arguments{
\item{C}{Cost variable}

\item{Cstar}{numeric; Cost parameter of the unlabeled objects}

\item{s}{numeric; parameter controlling the loss function of the unlabeled objects}

\item{x_center}{logical;  Should the features be centered?}

\item{scale}{Whether a z-transform should be applied (default: TRUE)}

\item{eps}{Small value to ensure positive definiteness of the matrix in QP formulation}

\item{verbose}{logical; Controls the verbosity of the output}

\item{init}{numeric; Initial classifier parameters to start the convex concave procedure}
}
\description{
model from RSSL package
Implementation of the Linear Support Vector Classifier. Can be solved in the Dual formulation, which is equivalent to \code{\link{SVM}} or the Primal formulation.
}
\examples{
library(tidyverse)
library(caret)
library(tidymodels)
library(SSLR)

data(breast)

set.seed(1)
train.index <- createDataPartition(breast$Class, p = .7, list = FALSE)
train <- breast[ train.index,]
test  <- breast[-train.index,]

cls <- which(colnames(breast) == "Class")

#\% LABELED
labeled.index <- createDataPartition(breast$Class, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA


m <- LinearTSVMSSLR() \%>\% fit(Class ~ ., data = train)


#Accesing model from RSSL
model <- m$model
}
