% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasMnist.R
\name{funKerasMnist}
\alias{funKerasMnist}
\title{funKerasMnist}
\usage{
funKerasMnist(x, kerasConf, data)
}
\arguments{
\item{x}{matrix of hyperparameter values to evaluate with the function.
Rows for points and columns for dimension.}

\item{kerasConf}{List of additional parameters passed to keras as described in \code{\link{getKerasConf}}.
Default: \code{kerasConf = getKerasConf()}.}

\item{data}{mnist data set. Default: \code{\link{getMnistData}}.}
}
\value{
1-column matrix with resulting function values (test loss)
}
\description{
Hyperparameter Tuning: Keras MNIST Classification Test Function.
}
\details{
Trains a simple deep NN on the MNIST dataset.
Provides a template that can be used for other networks as well.
Standard Code from https://keras.rstudio.com/
Modified by T. Bartz-Beielstein (tbb@bartzundbartz.de)
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE <- FALSE
if(PYTHON_RETICULATE){

library("SPOTMisc")
library("SPOT")
kerasConf <- getKerasConf()
## The following two settings are default:
kerasConf$encoding = "oneHot"
kerasConf$model = "dl"
## get the data with the correct encoding
mnist <- getMnistData(kerasConf)
## get the model
cfg <-  getModelConf(kerasConf)

### First example: simple function call:
x <- matrix(cfg$default, nrow=1)
if (length(cfg$transformations) > 0) {  x <- transformX(xNat=x, fn=cfg$transformations)}
funKerasMnist(x, kerasConf = kerasConf, data = mnist)
### Use convnet:
kerasConf <- getKerasConf()
kerasConf$encoding <- "tensor"
kerasConf$model <- "cnn"
mnist <- getMnistData(kerasConf)
cfg <-  getModelConf(kerasConf)
x <- matrix(cfg$default, nrow=1)
if (length(cfg$transformations) > 0) {  x <- transformX(xNat=x, fn=cfg$transformations)}
funKerasMnist(x, kerasConf = kerasConf, data=mnist)

### Second example: evaluation of several (three) hyperparameter settings:
x <- matrix(cfg$default, nrow=1)
if (length(cfg$transformations) > 0) {  x <- transformX(xNat=x, fn=cfg$transformations)}
xxx <- rbind(x,x,x)
funKerasMnist(xxx, kerasConf = kerasConf, data=mnist)

### Third example: spot call (dense network):
kerasConf <- getKerasConf()
kerasConf$verbose <- 0
kerasConf$encoding = "oneHot"
kerasConf$model = "dl"
## get the data with the correct encoding
mnist <- getMnistData(kerasConf)
## get the model
cfg <-  getModelConf(kerasConf)
## max 32 training epochs
cfg$upper[6] <- 5
resDl <- spot(x = NULL,
            fun = funKerasMnist,
            lower = cfg$lower,
            upper = cfg$upper,
            control = list(funEvals=15,
                         transformFun = cfg$transformations,
                         types = cfg$type,
                         noise = TRUE,
                         plots = TRUE,
                         progress = TRUE,
                         seedFun = 1,
                         seedSPOT = 1),
                         kerasConf = kerasConf,
                         data = mnist)

### Fourth example: spot call (convnet):
kerasConf <- getKerasConf()
kerasConf$verbose <- 1
kerasConf$encoding <- "tensor"
kerasConf$model <- "cnn"
## get the data with the correct encoding
mnist <- getMnistData(kerasConf)
## get the model
cfg <-  getModelConf(kerasConf)
## max 32 training epochs
cfg$upper[6] <- 5
resCnn <- spot(x = NULL,
            fun = funKerasMnist,
            lower = cfg$lower,
            upper = cfg$upper,
            control = list(funEvals=15,
                         transformFun = cfg$transformations,
                         types = cfg$type,
                         noise = TRUE,
                         plots = TRUE,
                         progress = TRUE,
                         seedFun = 1,
                         seedSPOT = 1),
                         kerasConf = kerasConf,
                         data = mnist)
}
}

}
\seealso{
\code{\link{getKerasConf}}

\code{\link{evalKerasMnist}}

\code{\link[keras]{fit}}
}
