% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funSring.R
\name{sring}
\alias{sring}
\title{sring}
\usage{
sring(x, opt = list(), ...)
}
\arguments{
\item{x}{perceptron weights}

\item{opt}{list of optional parameters, e.g., 
\describe{
    \item{\code{nElevators}}{number of elevators}
    \item{\code{probNewCustomer}}{probability pf a customer arrival}
    \item{\code{nIterations}}{Number of itertions}
    \item{\code{randomSeed}}{random seed}
  }}

\item{...}{additional parameters}
}
\value{
fitness
}
\description{
simple elevator simulator
}
\examples{
set.seed(123)
nStates = 6
nElevators = 2
sigma = 1
x = matrix( rnorm(n = 2*nStates, 1, sigma), 1,)
sring(x, opt = list(nElevators=nElevators,
                   nStates= nStates) )

}
