% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designLHD.R
\name{designLHD}
\alias{designLHD}
\title{Latin Hypercube Design Generator}
\usage{
designLHD(x = NULL, lower, upper, control = list())
}
\arguments{
\item{x}{optional matrix x, rows for points, columns for dimensions. This can contain one or more points which are part of the design, but specified by the user. These points are added to the design, 
and are taken into account when calculating the pair-wise distances. They do not count for the design size. E.g., if \code{x} has two rows, \code{control$replicates} is one and \code{control$size} is ten, the returned design will have
12 points (12 rows). The first two rows will be identical to \code{x}. Only the remaining ten rows are guaranteed to be a valid LHD.}

\item{lower}{vector with lower boundary of the design variables (in case of categorical parameters, please map the respective factor to a set of contiguous integers, e.g., with lower = 1 and upper = number of levels)}

\item{upper}{vector with upper boundary of the design variables (in case of categorical parameters, please map the respective factor to a set of contiguous integers, e.g., with lower = 1 and upper = number of levels)}

\item{control}{list of controls:\cr
\code{size} number of design points\cr
\code{retries} number of retries during design creation\cr
\code{types} this specifies the data type for each design parameter, as a vector of either "numeric","integer","factor". (here, this only affects rounding)\cr
\code{replicates} integer for replications of each design point. E.g., if replications is two, every design point will occur twice in the resulting matrix.}
}
\value{
matrix \code{design} \cr
- \code{design} has \code{length(lower)} columns and \code{(size + nrow(x))*control$replicates} rows.
All values should be within \code{lower <= design <= upper}
}
\description{
Creates a latin Hypercube Design (LHD) with user-specified dimension and number of design points.
LHDs are created repeatedly created at random. For each each LHD, the minimal pair-wise distance between design points is computed.
The design with the maximum of that minimal value is chosen.
}
\examples{
set.seed(1) #set RNG seed to make examples reproducible 
design <- designLHD(,1,2) #simple, 1-D case
design
design <- designLHD(,1,2,control=list(replicates=3)) #with replications
design
design <- designLHD(,c(-1,-2,1,0),c(1,4,9,1),
	control=list(size=5, retries=100, types=c("numeric","integer","factor","factor")))
design
x <- designLHD(,c(1,-10),c(2,10),control=list(size=5,retries=100))
x2 <- designLHD(x,c(1,-10),c(2,10),control=list(size=5,retries=100))
plot(x2)
points(x, pch=19)
}
\author{
Original code by Christian Lasarczyk, adaptations by Martin Zaefferer
}
