% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPAS.fit.model.R
\name{SPAS.fit.model}
\alias{SPAS.fit.model}
\title{Fit a Stratified-Petersen (SP) model using  TMB.}
\usage{
SPAS.fit.model(
  model.id = "Stratified Petersen Estimator",
  rawdata,
  row.pool.in,
  col.pool.in,
  row.physical.pool = TRUE,
  theta.pool = FALSE,
  CJSpool = FALSE,
  optMethod = c("nlminb"),
  optMethod.control = list(maxit = 50000),
  svd.cutoff = 1e-04,
  chisq.cutoff = 0.1
)
}
\arguments{
\item{model.id}{Character string identifying the name of the model including any pooling..}

\item{rawdata}{An (s+1) x (t+1) of the raw data BEFORE pooling.
The s x t upper left matrix is the number of animals released in row stratum i and recovered in
column stratum j. Row s+1 contains the total number of UNMARKED animals recovered in column stratum j.
Column t+1 contains the number of animals marked in each row stratum but not recovered in any column stratum.
The rawdata[s+1, t+1] is not used and can be set to 0 or NA.
The sum of the entries in each of the first s rows is then the number of animals marked in each row stratum.
The sum of the entries in each of the first t columns is then the number of animals captured (marked and unmarked) in each column stratum.
The row/column names of the matrix may be set to identify the entries in the output.}

\item{row.pool.in, col.pool.in}{Vectors (character/numeric) of length s and t respectively. These identify the rows/columns to be pooled before the analysis is done.
The vectors consists of entries where pooling takes place if the entries are the same. For example, if s=4, then 
row.pool.in = c(1,2,3,4) implies no pooling because all entries are distinct; row.pool.in=c("a","a","b","b") implies that the 
first two rows will be pooled and the last two rows will be pooled. It is not necessary that row/columns be continuous to be pooled, but
this is seldom sensible. A careful choice of pooling labels helps to remember what as done, e.g. row.pool.in=c("123","123","123","4") indicates
that the first 3 rows are pooled and the 4th row is not pooled. Character entries ensure that the resulting matrix is sorted properly (e.g. if 
row.pool.in=c(123,123,123,4), then the same pooling is done, but the matrix rows are sorted rather strangely.}

\item{row.physical.pool}{Should physical pooling be done (default) or should logical pooling be done. For example, if there are 3 rows in 
the data matrix and row.pool.in=c(1,1,3), then in physical pooling, the entries in rows 1 and 2 are physically added together to create
2 rows in the data matrix before fitting. Because the data has changed, you cannot compare physical pooling using AIC. In logical pooling,
the data matrix is unchanged, but now parameters p1=p2 but the movement parameters for the rest of the matrix are not forced equal.}

\item{theta.pool, CJSpool}{NOT YET IMPLEMENTED. DO NOT CHANGE.}

\item{optMethod}{What optimization method is used. Defaults is the nlminb() function..}

\item{optMethod.control}{Control parameters for optimization method. See the documentation on the different optimization methods for details.}

\item{svd.cutoff}{When finding the variance-covariance matrix, a singular value decomposition is used. This identifies the smallest 
singular value to retain.}

\item{chisq.cutoff}{When finding a goodness of fit statistic using (obs-exp)^2/exp, all cell whose Exp < gof.cutoff are ignored
to try and remove structural zero cells.}
}
\value{
A list with many entries. Refer to the vignettes for more details.
}
\description{
This function fits a Stratified-Petersen (Plante, 1996) to data and specify which rows/columns of the data
should be pooled. The number of rows after pooling should be <= number of columns after
pooling
.
}
\examples{
conne.data.csv <- textConnection("
9  ,    21  ,     0  ,    0  ,    0  ,    0  ,   171
0  ,   101  ,    22  ,    1  ,    0  ,    0  ,   763
0  ,     0  ,   128  ,   49  ,    0  ,    0  ,   934
0  ,     0  ,     0  ,   48  ,   12  ,    0  ,   434
0  ,     0  ,     0  ,    0  ,    7  ,    0  ,    49
0  ,     0  ,     0  ,    0  ,    0  ,    0  ,     4
351,  2736  ,  3847  , 1818  ,  543  ,   191 ,     0")
conne.data <- as.matrix(read.csv(conne.data.csv, header=FALSE))
close(conne.data.csv)
 
mod1 <- SPAS.fit.model(conne.data, model.id="Pooling rows 1/2, 5/6; pooling columns 5/6",
                      row.pool.in=c("12","12","3","4","56","56"),
                      col.pool.in=c(1,2,3,4,56,56))

}
