% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{initGrid}
\alias{initGrid}
\title{Create an Empty Grid}
\usage{
initGrid(
  dimension = c(5, 5),
  topo = c("square", "hexagonal"),
  dist.type = c("euclidean", "maximum", "manhattan", "canberra", "minkowski", "letremy")
)
}
\arguments{
\item{dimension}{a 2-dimensional vector giving the dimensions (width, length)
of the grid}

\item{topo}{topology of the grid. Accept values \code{"square"} (Default) or
\code{"hexagonal"}.}

\item{dist.type}{distance type that defines the topology of the grid (see
'Details'). Default to \code{"euclidean"}}
}
\value{
an object of class \code{myGrid} with the following entries:
\itemize{
  \item{\code{coord}} 2-column matrix with x and y coordinates of the grid 
  units
  \item{\code{topo}} topology of the grid;
  \item{\code{dim}} dimensions of the grid (width corresponds to x 
  coordinates)
  \item{\code{dist.type}} distance type that defines the topology of the 
  grid.
}
}
\description{
Create an empty (square) grid equipped with topology.
}
\details{
The units (neurons) of the grid are positionned at coordinates 
(1,1), (1,2), (1,3), ..., (2,1), (2,2), ..., for the \code{square} topology.
The topology of the map is defined by a distance based on those coordinates, 
that can be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, 
\code{"canberra"}, \code{"minkowski"}, \code{"letremy"}, where the first 5 
ones correspond to distance methods implemented in \code{\link{dist}} and 
\code{"letremy"} is the distance of the original implementation by Patrick 
Letrémy that switches between \code{"maximum"} and \code{"euclidean"} during
the training.
}
\examples{
initGrid()
initGrid(dimension=c(5, 7), dist.type = "maximum")

}
\references{
Letrémy P. (2005) Programmes basés sur l'algorithme de Kohonen 
et dédiés à l'analyse des données. SAS/IML programs for 'korresp'.
}
\seealso{
\code{\link{plot.myGrid}} for plotting the grid
}
\author{
Élise Maigné \email{elise.maigne@inrae.fr}\cr
Madalina Olteanu \email{olteanu@ceremade.dauphine.fr}\cr
Nathalie Vialaneix \email{nathalie.vialaneix@inrae.fr}
}
