% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMITIDvisu.R, R/maptt.R, R/mstVariant.R,
%   R/timeLine.R, R/transmissionTree.R
\name{SMITIDvisu-shiny}
\alias{SMITIDvisu-shiny}
\alias{mapttOutput}
\alias{renderMaptt}
\alias{mstVariantOutput}
\alias{rendermstVariant}
\alias{timeLineOutput}
\alias{renderTimeLine}
\alias{transmissionTreeOutput}
\alias{renderTransmissionTree}
\title{Shiny bindings for visualisation widgets}
\usage{
mapttOutput(outputId, width = "100\%", height = "400px")

renderMaptt(expr, env = parent.frame(), quoted = FALSE)

mstVariantOutput(outputId, width = "100\%", height = "600px")

rendermstVariant(expr, env = parent.frame(), quoted = FALSE)

timeLineOutput(outputId, width = "100\%", height = "400px")

renderTimeLine(expr, env = parent.frame(), quoted = FALSE)

transmissionTreeOutput(outputId, width = "100\%", height = "500px")

renderTransmissionTree(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended.}

\item{expr}{An expression that generates a networkD3 graph}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using visualisation widgets within Shiny
applications and interactive Rmd documents.
}
