% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotCoocMutex}
\alias{plotCoocMutex}
\title{plotCoocMutex}
\usage{
plotCoocMutex(maffile, mutcell.summary, cellnumcuoff = 3)
}
\arguments{
\item{maffile}{The name of mutation annotation file (MAF) format data. It must be an absolute path or the name  relatived to the current working directory.}

\item{mutcell.summary}{The result of `mutcellsummary` function}

\item{cellnumcuoff}{A threshold value (4 as the default value). The mutation genes which drive at least "cellnumcuoff" cells are retained for drawing a co-occurrence and mutual exclusivity plots.}
}
\description{
Function `plotCoocMutex` plots the co-occurrence and mutual exclusivity plots for mutation genes which drive immune cells.
}
\examples{
cellmatrix<-GetExampleData("cellmatrix") # Cell abundance matrix
mutmatrix<-GetExampleData("mutmatrix") # A binary mutations matrix
mutcell<-GetExampleData("mutcell") # The result of `mutcorcell` funtion
summary<-summary<-mutcellsummary(mutcell = mutcell,mutmatrix = mutmatrix,cellmatrix=cellmatrix)
file<-"dir" #dir must be an absolute path or the name  relatived to the current working directory.
\donttest{plotCoocMutex(maffile = dir,mutcell.summary = summary,cellnumcuoff =0)}
}
\references{
Gerstung M, Pellagatti A, Malcovati L, et al. Combining gene mutation with gene expression data improves outcome prediction in myelodysplastic syndromes. Nature Communications. 2015;6:5901. doi:10.1038/ncomms6901.
}
