% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainSLOPE.R
\name{trainSLOPE}
\alias{trainSLOPE}
\title{Train a SLOPE model}
\usage{
trainSLOPE(
  x,
  y,
  q = 0.2,
  number = 10,
  repeats = 1,
  measure = c("mse", "mae", "deviance", "missclass", "auc"),
  ...
)
}
\arguments{
\item{x}{the design matrix, which can be either a dense
matrix of the standard \emph{matrix} class, or a sparse matrix
inheriting from \link[Matrix:sparseMatrix]{Matrix::sparseMatrix}. Data frames will
be converted to matrices internally.}

\item{y}{the response, which for \code{family = "gaussian"} must be numeric; for
\code{family = "binomial"} or \code{family = "multinomial"}, it can be a factor.}

\item{q}{parameter controlling the shape of the lambda sequence, with
usage varying depending on the type of path used and has no effect
is a custom \code{lambda} sequence is used.}

\item{number}{number of folds (cross-validation)}

\item{repeats}{number of repeats for each fold (for repeated \emph{k}-fold cross
validation)}

\item{measure}{measure to try to optimize; note that you may
supply \emph{multiple} values here and that, by default,
all the possible measures for the given model will be used.}

\item{...}{other arguments to pass on to \code{\link[=SLOPE]{SLOPE()}}}
}
\value{
An object of class \code{"TrainedSLOPE"}, with the following slots:
\item{summary}{a summary of the results with means, standard errors,
and 0.95 confidence levels}
\item{data}{the raw data from the model training}
\item{optima}{a \code{data.frame} of the best (mean) values for the different metrics and their corresponding parameter values}
\item{measure}{a \code{data.frame} listing the used metrics and their labels}
\item{model}{the model fit to the entire data set}
\item{call}{the call}
}
\description{
This function trains a model fit by \code{\link[=SLOPE]{SLOPE()}} by tuning its parameters
through cross-validation.
}
\details{
Note that by default this method matches all of the available metrics
for the given model family against those provided in the argument
\code{measure}. Collecting these measures is not particularly demanding
computationally so it is almost always best to leave this argument
as it is and then choose which argument to focus on in the call
to \code{\link[=plot.TrainedSLOPE]{plot.TrainedSLOPE()}}.
}
\section{Parallel operation}{

This function uses the \strong{foreach} package to enable parallel
operation. To enable this, simply register a parallel backend
using, for instance, \code{doParallel::registerDoParallel()} from the
\strong{doParallel} package before running this function.
}

\examples{
# 8-fold cross-validation repeated 5 times
tune <- trainSLOPE(subset(mtcars, select = c("mpg", "drat", "wt")),
                   mtcars$hp,
                   q = c(0.1, 0.2),
                   number = 8,
                   repeats = 5)
}
\seealso{
\code{\link[foreach:foreach]{foreach::foreach()}}, \code{\link[=plot.TrainedSLOPE]{plot.TrainedSLOPE()}}

Other model-tuning: 
\code{\link{caretSLOPE}()},
\code{\link{plot.TrainedSLOPE}()}
}
\concept{model-tuning}
