% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getQtlGeno}
\alias{getQtlGeno}
\alias{getQueenQtlGeno}
\alias{getFathersQtlGeno}
\alias{getVirginQueensQtlGeno}
\alias{getWorkersQtlGeno}
\alias{getDronesQtlGeno}
\title{Access QTL genotypes of individuals in a caste}
\usage{
getQtlGeno(
  x,
  caste = NULL,
  nInd = NULL,
  trait = 1,
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

getQueenQtlGeno(x, trait = 1, chr = NULL, collapse = FALSE, simParamBee = NULL)

getFathersQtlGeno(
  x,
  nInd = NULL,
  trait = 1,
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

getVirginQueensQtlGeno(
  x,
  nInd = NULL,
  trait = 1,
  chr = NULL,
  collapse = FALSE,
  simParamBee = NULL
)

getWorkersQtlGeno(
  x,
  nInd = NULL,
  trait = 1,
  chr = NULL,
  collapse = FALSE,
  simParamBee = NULL
)

getDronesQtlGeno(
  x,
  nInd = NULL,
  trait = 1,
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}}, \code{\link[SIMplyBee]{Colony-class}}, or
\code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link[AlphaSimR]{Pop-class}},
and character when \code{x} is a \code{\link[SIMplyBee]{Colony-class}} or
 \code{\link[SIMplyBee]{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, number of individuals to access, if \code{NULL} all
individuals are accessed, otherwise a random sample}

\item{trait}{numeric (trait position) or character (trait name), indicates
which trait's QTL genotypes to retrieve}

\item{chr}{numeric, chromosomes to retrieve, if \code{NULL}, all chromosome
are retrieved}

\item{dronesHaploid}{logical, return haploid result for drones?}

\item{collapse}{logical, if the return value should be a single matrix
with genotypes of all the individuals}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
matrix with genotypes when \code{x} is \code{\link[SIMplyBee]{Colony-class}} and
  list of matrices with genotypes when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}, named by colony id when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 0 function that returns QTL genotypes of individuals in a
  caste.
}
\section{Functions}{
\itemize{
\item \code{getQueenQtlGeno()}: Access QTL genotype data of the queen

\item \code{getFathersQtlGeno()}: Access QTL genotype data of fathers

\item \code{getVirginQueensQtlGeno()}: Access QTL genotype data of virgin queens

\item \code{getWorkersQtlGeno()}: Access QTL genotype data of workers

\item \code{getDronesQtlGeno()}: Access QTL genotype data of drones

}}
\examples{
founderGenomes <- quickHaplo(nInd = 4, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(nQtlPerChr = 10)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 200)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(x = colony, nInd = 5)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(x = apiary, nInd = 5)

# Input is a population
getQtlGeno(x = getQueen(colony))
queens <- getQueen(apiary, collapse = TRUE)
getQtlGeno(queens)

# Input is a colony
getQtlGeno(colony, caste = "queen")
getQueenQtlGeno(colony)

getQtlGeno(colony, caste = "workers", nInd = 3)
getWorkersQtlGeno(colony)
# Same aliases exist for all the castes!

# Get genotypes for all individuals
getQtlGeno(colony, caste = "all")
# Get all haplotypes in a single matrix
getQtlGeno(colony, caste = "all", collapse = TRUE)

# Input is a MultiColony - same behaviour as for the Colony!
getQtlGeno(apiary, caste = "queen")
getQueenQtlGeno(apiary)

# Get the genotypes of all individuals either by colony or in a single matrix
getQtlGeno(apiary, caste = "all")
getQtlGeno(apiary, caste = "all", collapse = TRUE)
}
\seealso{
\code{\link[SIMplyBee]{getQtlGeno}} and \code{\link[AlphaSimR]{pullQtlGeno}} as well as
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
