% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{isEmpty}
\alias{isEmpty}
\title{Check whether a population, colony or a multicolony
  object has no individuals within}
\usage{
isEmpty(x)
}
\arguments{
\item{x}{\code{\link{Pop-class}} or \code{\link{Colony-class}} or
\code{\link{MultiColony-class}}}
}
\value{
boolean when \code{x} is \code{\link{Pop-class}} or
  \code{\link{Colony-class}}, and named vector of boolean when
  \code{x} is \code{\link{MultiColony-class}}
}
\description{
Check whether a population, colony or a multicolony
  object has no individuals within.
}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

isEmpty(new(Class = "Pop"))
isEmpty(basePop[0])
isEmpty(basePop)

emptyColony <- createColony()
nonEmptyColony <- createColony(basePop[1])
isEmpty(emptyColony)
isEmpty(nonEmptyColony)

emptyApiary <- createMultiColony(n = 3)
emptyApiary1 <- c(createColony(), createColony())
emptyApiary2 <- createMultiColony()
nonEmptyApiary <- createMultiColony(basePop[2:5], n = 4)

isEmpty(emptyApiary)
isEmpty(emptyApiary1)
isEmpty(nonEmptyApiary)
isNULLColonies(emptyApiary)
isNULLColonies(emptyApiary1)
isNULLColonies(nonEmptyApiary)

nEmptyColonies(emptyApiary)
nEmptyColonies(emptyApiary1)
nEmptyColonies(nonEmptyApiary)
nNULLColonies(emptyApiary)
nNULLColonies(emptyApiary1)
nNULLColonies(nonEmptyApiary)

}
