% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{hasSwarmed}
\alias{hasSwarmed}
\title{Test if colony has swarmed}
\usage{
hasSwarmed(x)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}
}
\value{
logical, named by colony id when \code{x} is \code{\link{MultiColony-class}}
}
\description{
Level 0 function that returns colony swarmed status. This will
  obviously have major impact on the colony and its downstream events.
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(colony, nInd = 5)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)

hasSwarmed(colony)
tmp <- swarm(colony)
hasSwarmed(tmp$swarm)
hasSwarmed(tmp$remnant)

hasSwarmed(apiary)
tmp2 <- swarm(apiary)
hasSwarmed(tmp2$swarm)
hasSwarmed(tmp2$remnant)
}
