% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getSegSiteGeno}
\alias{getSegSiteGeno}
\alias{getQueenSegSiteGeno}
\alias{getFathersSegSiteGeno}
\alias{getVirginQueensSegSiteGeno}
\alias{getWorkersSegSiteGeno}
\alias{getDronesSegSiteGeno}
\title{Access genotypes for all segregating sites of individuals in a
  caste}
\usage{
getSegSiteGeno(
  x,
  caste = NULL,
  nInd = NULL,
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

getQueenSegSiteGeno(x, chr = NULL, collapse = FALSE, simParamBee = NULL)

getFathersSegSiteGeno(
  x,
  nInd = NULL,
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

getVirginQueensSegSiteGeno(
  x,
  nInd = NULL,
  chr = NULL,
  collapse = FALSE,
  simParamBee = NULL
)

getWorkersSegSiteGeno(
  x,
  nInd = NULL,
  chr = NULL,
  collapse = FALSE,
  simParamBee = NULL
)

getDronesSegSiteGeno(
  x,
  nInd = NULL,
  chr = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)
}
\arguments{
\item{x}{\code{\link{Pop-class}}, \code{\link{Colony-class}}, or
\code{\link{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link{Pop-class}},
and character when \code{x} is a \code{\link{Colony-class}} or
 \code{\link{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, number of individuals to access, if \code{NULL} all
individuals are accessed, otherwise a random sample}

\item{chr}{numeric, chromosomes to retrieve, if \code{NULL}, all chromosome
are retrieved}

\item{dronesHaploid}{logical, return haploid result for drones?}

\item{collapse}{logical, if the return value should be a single matrix
with genotypes of all the individuals}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
matrix with genotypes when \code{x} is \code{\link{Colony-class}} and
  list of matrices with genotypes when \code{x} is
  \code{\link{MultiColony-class}}, named by colony id when \code{x} is
  \code{\link{MultiColony-class}}
}
\description{
Level 0 function that returns genotypes for all segregating
  sites of individuals in a caste.
}
\section{Functions}{
\itemize{
\item \code{getQueenSegSiteGeno()}: Access genotype data for all segregating sites of the queen

\item \code{getFathersSegSiteGeno()}: Access genotype data for all segregating sites of fathers

\item \code{getVirginQueensSegSiteGeno()}: Access genotype data for all segregating sites of virgin queens

\item \code{getWorkersSegSiteGeno()}: Access genotype data for all segregating sites of workers

\item \code{getDronesSegSiteGeno()}: Access genotype data for all segregating sites of drones

}}
\examples{
founderGenomes <- quickHaplo(nInd = 4, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(x = colony, nInd = 5)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(x = apiary, nInd = 5)

# Input is a population
getSegSiteGeno(x = getQueen(colony))
queens <- getQueen(apiary, collapse = TRUE)
getSegSiteGeno(queens)

# Input is a colony
getSegSiteGeno(colony, caste = "queen")
getQueenSegSiteGeno(colony)

getSegSiteGeno(colony, caste = "workers", nInd = 3)
getWorkersSegSiteGeno(colony)
# same aliases exist for all the castes!

# Get genotypes for all individuals
getSegSiteGeno(colony, caste = "all")
# Get all genotypes in a single matrix
getSegSiteGeno(colony, caste = "all", collapse = TRUE)

# Input is a MultiColony - same behaviour as for the Colony
getSegSiteGeno(apiary, caste = "queen")
getQueenSegSiteGeno(apiary)

# Get the genotypes of all individuals either by colony or in a single matrix
getSegSiteGeno(apiary, caste = "all")
getSegSiteGeno(apiary, caste = "all", collapse = TRUE)
}
\seealso{
\code{\link{getSegSiteGeno}} and \code{\link{pullSegSiteGeno}}
}
