% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getQueenAge}
\alias{getQueenAge}
\title{Get (calculate) the queen's age}
\usage{
getQueenAge(x, currentYear)
}
\arguments{
\item{x}{\code{\link{Pop-class}}, \code{\link{Colony-class}}, or
\code{\link{MultiColony-class}}}

\item{currentYear}{integer, current year}
}
\value{
numeric, the age of the queen(s); named when theres is more
  than one queen; \code{NA} if queen not present
}
\description{
Level 0 function that returns the queen's age.
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])

queen <- getQueen(colony)
queen <- setQueensYearOfBirth(queen, year = 2020)
getQueenAge(queen, currentYear = 2022)

colony <- setQueensYearOfBirth(colony, year = 2021)
getQueenAge(colony, currentYear = 2022)

apiary <- setQueensYearOfBirth(apiary, year = 2018)
getQueenAge(apiary, currentYear = 2022)
}
