% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getPooledGeno}
\alias{getPooledGeno}
\title{Get a pooled genotype from true genotypes}
\usage{
getPooledGeno(x, type = NULL, sex = NULL)
}
\arguments{
\item{x}{matrix, true genotypes with individuals in rows and sites in columns}

\item{type}{character, "mean" for average genotype or "count" for the counts
of reference and alternative alleles}

\item{sex}{character, vector of "F" and "M" to denote the sex of individuals
in \code{x}}
}
\value{
a numeric vector with average allele dosage when \code{type = "mean"}
  and a two-row matrix with the counts of reference (1st row) and
  alternative (2nd row) alleles
}
\description{
Level 0 function that returns a pooled genotype from true
  genotypes to mimic genotyping of a pool of colony members.
}
\examples{
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)

basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)
apiary <- createMultiColony(basePop[2:3], n = 2)
apiary <- cross(x = apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(x = apiary, nInd = 5)

genoQ <- getQueenSegSiteGeno(apiary[[1]])
genoF <- getFathersSegSiteGeno(apiary[[1]])
genoW <- getWorkersSegSiteGeno(apiary[[1]])
genoD <- getDronesSegSiteGeno(apiary[[1]])
genoV <- getVirginQueensSegSiteGeno(apiary[[1]])

# Pool of drones
sexD <- getCasteSex(apiary[[1]], caste = "drones")
getPooledGeno(x = genoD, type = "count", sex = sexD)[, 1:10]
(poolD <- getPooledGeno(x = genoD, type = "mean", sex = sexD))[, 1:10]
# ... compare to queen's genotype
genoQ[, 1:10]
plot(
  y = poolD, x = genoQ, ylim = c(0, 2), xlim = c(0, 2),
  ylab = "Average allele dosage in drones",
  xlab = "Allele dosage in the queen"
)

# As an exercise you could repeat the above with different numbers of drones!

# Pool of workers
getPooledGeno(x = genoW, type = "count")[, 1:10]
(poolW <- getPooledGeno(x = genoW, type = "mean"))[, 1:10]
# ... compare to fathers' and queen's avearage genotype
sexF <- getCasteSex(apiary[[1]], caste = "fathers")
sexQ <- rep(x = "F", times = nrow(genoF))
sexFQ <- c(sexF, sexQ)
genoFQ <- rbind(genoF, genoQ[rep(x = 1, times = nrow(genoF)), ])
(poolFQ <- getPooledGeno(x = genoFQ, type = "mean", sex = sexFQ))[, 1:10]
plot(
  y = poolW, x = poolFQ, ylim = c(0, 2), xlim = c(0, 2),
  ylab = "Average allele dosage in workers",
  xlab = "Average allele dosage in the queen and fathers"
)

# As an exercise you could repeat the above with different numbers of workers!

}
