% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getDd}
\alias{getDd}
\alias{getQueenDd}
\alias{getFathersDd}
\alias{getVirginQueensDd}
\alias{getWorkersDd}
\alias{getDronesDd}
\title{Access dominance values of individuals in a caste}
\usage{
getDd(x, caste = NULL, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getQueenDd(x, collapse = FALSE, simParamBee = NULL)

getFathersDd(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getVirginQueensDd(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getWorkersDd(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getDronesDd(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}, \code{\link{Colony-class}}, or
\code{\link{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link{Pop-class}},
and character when \code{x} is a \code{\link{Colony-class}} or
 \code{\link{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, number of individuals to access, if \code{NULL} all
individuals are accessed, otherwise a random sample}

\item{collapse}{logical, if the return value should be a single matrix
with dominance values of all the individuals}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
vector of dominance values when \code{x} is
  \code{\link{Colony-class}} and list of vectors of dominance values when
  \code{x} is \code{\link{MultiColony-class}}, named by colony id when \code{x}
  is \code{\link{MultiColony-class}}

# Not exporting this function, since the theory behind it is not fully developed
}
\description{
Level 0 function that returns dominance values of
  individuals in a caste.
}
\section{Functions}{
\itemize{
\item \code{getQueenDd()}: Access dominance value of the queen

\item \code{getFathersDd()}: Access dominance values of fathers

\item \code{getVirginQueensDd()}: Access dominance values of virgin queens

\item \code{getWorkersDd()}: Access dominance values of workers

\item \code{getDronesDd()}: Access dominance values of drones

}}
\seealso{
\code{\link{dd}} and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
