% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{calcSelectionCriterion}
\alias{calcSelectionCriterion}
\title{Calculate the selection criterion}
\usage{
calcSelectionCriterion(
  x,
  queenTrait = 1,
  queenTraitFUN = sum,
  workersTrait = 2,
  workersTraitFUN = sum,
  use = "gv"
)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{queenTrait}{numeric (column position) or character (column name), trait
that represents queen's effect on the colony value; if \code{NULL} then this contribution is 0}

\item{queenTraitFUN}{function, that will be applied to the queen effect
values of workers, default is sum (see examples), but note that the correct
function will depend on how you will setup simulation!}

\item{workersTrait}{numeric (column position) or character (column name), trait
that represents workers' effect on the colony value; if \code{NULL} then this contribution is 0}

\item{workersTraitFUN}{function, that will be applied to the workers effect
values of workers, default is sum (see examples), but note that the correct
function will depend on how you will setup simulation!}

\item{use}{character, the measure to use for the calculation, being
either "gv" (genetic value), "ebv" (estimated breeding value),
or "pheno" (phenotypic value)}
}
\value{
integer when \code{x} is
  \code{\link{Colony-class}} and a named list when \code{x} is
  \code{\link{MultiColony-class}}, where names are colony IDs
}
\description{
Level 0 function that calculates the selection criterion as the
  sum of workers (direct) and queen (maternal) effects of workers,
  as defined by Du et al. (2021). This can be seen as the expected value
  of virgin queens from the queen (as well as workers, but we would not be
  selecting workers).
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
meanA <- c(10, 10 / SP$nWorkers)
varA <- c(1, 1 / SP$nWorkers)
corA <- matrix(data = c( 1.0, -0.5,
                        -0.5,  1.0), nrow = 2, byrow = TRUE)
SP$addTraitA(nQtlPerChr = 100, mean = meanA, var = varA, corA = corA,
name = c("queenTrait", "workersTrait"))
varE <- c(3, 3 / SP$nWorkers)
corE <- matrix(data = c(1.0, 0.3,
                        0.3, 1.0), nrow = 2, byrow = TRUE)
SP$setVarE(varE = varE, corE = corE)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(colony)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(apiary)

calcSelectionCriterion(colony,
                       queenTrait = 1, queenTraitFUN = sum,
                       workersTrait = 2, workersTraitFUN = sum)
calcSelectionCriterion(apiary,
                       queenTrait = 1, queenTraitFUN = sum,
                       workersTrait = 2, workersTraitFUN = sum)

apiary[[2]] <- removeQueen(apiary[[2]])
calcSelectionCriterion(apiary, queenTrait = 1,
                       workersTrait = 2, workersTraitFUN = sum)

}
\references{
Du, M., et al. (2021) Short-term effects of controlled mating and selection
  on the genetic variance of honeybee populations. Heredity 126, 733–747.
  \doi{/10.1038/s41437-021-00411-2}
}
\seealso{
\code{\link{calcInheritanceCriterion}} and
  \code{\link{calcPerformanceCriterion}} and  as well as
}
