% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{ci.QF}
\alias{ci.QF}
\title{Confidence Intervals for Bias-corrected QF Estimators}
\usage{
\method{ci}{QF}(
  object,
  probability = FALSE,
  alpha = 0.05,
  alternative = c("two.sided", "less", "greater"),
  ...
)
}
\arguments{
\item{object}{An object of class `QF`, a result of a call to `QF`}

\item{probability}{Whether returns CI with probability transformation or not (default=\code{FALSE})}

\item{alpha}{Level of significance to construct confidence interval (default=0.05)}

\item{alternative}{Indicates the alternative hypothesis to construct confidence interval and must be one of "two.sided" (default), "less", or "greater".}

\item{...}{arguments to pass down}
}
\value{
A matrix with columns giving lower and upper confidence limits for bias-corrected
estimators, with rows corresponding to different tau.
}
\description{
Computes confidence intervals for bias-corrected estimators; Each
row corresponds to a tau value.
}
\examples{
\dontrun{
##-- Continuing the QF(.) example:
out = ci(Est)
out
}
}
\keyword{internal}
