% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipseBackTransform.R
\name{ellipseBackTransform}
\alias{ellipseBackTransform}
\title{Back-transform a z-score siber ellipse to original location and scale.}
\usage{
ellipseBackTransform(jags.output, siber, idx.community, idx.group)
}
\arguments{
\item{jags.output}{a mcmc.list object of posterior samples created by 
\code{\link[rjags]{rjags}}. In siber this is created typically by 
\code{\link{fitEllipse}}}

\item{siber}{a siber object as created by createSiberObject.}

\item{idx.community}{an integer specifying which community to back-transform.}

\item{idx.group}{an integer specifyging which group to back-transform.}
}
\value{
A 6 x n matrix representing the back-transformed posterior 
distributions of the bivariate normal distribution for a specified group 
within a specified community, where n is the number of
posterior draws in the saved sample. The first four columns are the 
covariance matrix Sigma in vector format. This vector converts to the 
covariance matrix as \code{matrix(v[1:4], nrow = 2, ncol = 2)}. The 
remaining two columns are the back-transformed means.
}
\description{
Back-transforms a bivariate siber ellipse fitted to z-scored data to the 
original location and scale. Not intended for direct call by users.
}

