% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean2.2014CLX.R
\name{mean2.2014CLX}
\alias{mean2.2014CLX}
\title{Two-sample Test for High-Dimensional Means by Cai, Liu, and Xia (2014)}
\usage{
mean2.2014CLX(X, Y, Omega = NULL, cov.equal = TRUE)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}

\item{Omega}{precision matrix; if \code{NULL}, it applies CLIME estimation. Otherwise, 
a \eqn{(p\times p)} inverse covariance should be provided.}

\item{cov.equal}{a logical to determine homogeneous covariance assumption.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two multivariate data \eqn{X} and \eqn{Y} of same dimension, it tests
\deqn{H_0 : \mu_x = \mu_y\quad vs\quad H_1 : \mu_x \neq \mu_y}
using the procedure by Cai, Liu, and Xia (2014). Since the test is equivalent to testing 
\deqn{H_0 : \Omega(\mu_x - \mu_y)=0},
if \eqn{\Omega}, an inverse covariance (or precision), is not provided, it finds 
a sparse precision matrix via CLIME estimator. Also, if two samples 
are assumed to have different covariance structure, it uses weighting scheme for adjustment.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
smallY = matrix(rnorm(10*3),ncol=3)
mean2.2014CLX(smallX, smallY) # run the test

\dontrun{
## empirical Type 1 error 
niter   = 100
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(50*5), ncol=10)
  Y = matrix(rnorm(50*5), ncol=10)
  
  counter[i] = ifelse(mean2.2014CLX(X, Y)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'mean2.2014CLX'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{cai_twosample_2014}{SHT}
}
\concept{mean_multivariate}
