% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condDirichlet.R
\name{condDirichlet}
\alias{condDirichlet}
\title{Plot conditional distributions from an elicited Dirichlet prior}
\usage{
condDirichlet(d)
}
\arguments{
\item{d}{A fitted Dirichlet distribution, produced from a \code{fitDirichlet} command.}
}
\description{
Opens up a web browser (using the shiny package), from which you can choose to condition
on one of the category probability values, and then display the resulting conditional marginal
distributions for the remaining categories
}
\details{
Press Esc in the R console window to exit the elicitation session.
}
\examples{
\dontrun{
p1 <- c(0.25, 0.5, 0.75)
v1 <- c(0.5, 0.55, 0.6)
v2 <- c(0.22, 0.3, 0.35)
v3 <- c(0.11, 0.15, 0.2)
myfit1 <- fitdist(v1, p1, 0, 1)
myfit2 <- fitdist(v2, p1, 0, 1)
myfit3 <- fitdist(v3, p1, 0, 1)
d <- fitDirichlet(myfit1, myfit2, myfit3,
                  categories = c("A","B","C"),
                  n.fitted = "opt")
condDirichlet(d)
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
