% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter.R
\name{dupfilter}
\alias{dupfilter}
\title{Filter temporal and/or spatial duplicates}
\usage{
dupfilter(sdata, step.time = 0, step.dist = 0, conditional = FALSE)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
The function filters the input data by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. 
"lat" and "lon" are the latitude and longitude of each location in decimal degrees. 
"qi" is the numerical quality index associated with each location fix where a greater number indicates a higher accuracy 
(e.g. the number of GPS satellites involved in estimation).}

\item{step.time}{Consecutive locations less than or equal to \emph{step.time} apart are considered temporal duplicates.
Default is 0 hours.}

\item{step.dist}{Consecutive locations less than or equal to \emph{step.dist} apart are considered spatial duplicates.
Default is 0 kilometres.}

\item{conditional}{If TRUE, spatial duplicates are filtered only if they are less than or equal to \emph{step.time} apart. 
Default is FALSE.}
}
\value{
The input data frame is returned containing only a single fix (latitude/longitude pair) per time and location.
}
\description{
Function to filter temporal and spatial duplicates in tracking data 
and retain only a single fix per time and location.
}
\details{
This function filters temporal and spatial duplicates in tracking data.
It first filters temporally and spatially exact locations. 
It then looks for temporal duplicates and retains a fix with the highest quality index.
When temporal or spatial duplicates are associated with the same quality index, 
the function retains a location that is nearest from a previous and to a subsequent location.
}
\examples{
#### Load data sets
## Fastloc GPS data obtained from a green turtle
data(turtle)


#### Apply dupfilter
turtle.dup <- dupfilter(turtle)
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
\emph{Marine Biology} 163:1-14 doi:\href{http://doi.org/10.1007/s00227-015-2771-0}{10.1007/s00227-015-2771-0}
}
\seealso{
\code{\link{dupfilter_exact}}, \code{\link{dupfilter_qi}}, \code{\link{dupfilter_time}}, \code{\link{dupfilter_space}}, \code{\link{track_param}}
}
\author{
Takahiro Shimada
}
