% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple.synth.R
\name{multiple.synth}
\alias{multiple.synth}
\alias{multiple_synth}
\title{Function to Apply Synthetic Controls to Multiple Treated Units}
\usage{
multiple.synth(foo, predictors, predictors.op, dependent, unit.variable,
  time.variable, special.predictors, treated.units, control.units,
  time.predictors.prior, time.optimize.ssr, unit.names.variable, time.plot,
  treatment.time, gen.placebos = FALSE, strategy = "sequential",
  Sigf.ipop = 5)

multiple_synth(foo, predictors, predictors.op, dependent, unit.variable,
  time.variable, special.predictors, treated.units, control.units,
  time.predictors.prior, time.optimize.ssr, unit.names.variable, time.plot,
  treatment.time, gen.placebos = FALSE, strategy = "sequential",
  Sigf.ipop = 5)
}
\arguments{
\item{foo}{Dataframe with the panel data.}

\item{predictors}{Vector of column numbers or column-name character strings 
that identifies the predictors' columns. All predictors have to be numeric.}

\item{predictors.op}{A character string identifying the method (operator) 
to be used on the predictors. Default is \code{mean}.}

\item{dependent}{The column number or a string with the column name that 
corresponds to the dependent variable.}

\item{unit.variable}{The column number or a string with the column name 
that identifies unit numbers. The variable must be numeric.}

\item{time.variable}{The column number or a string with the column name 
that identifies the period (time) data. The variable must be numeric.}

\item{special.predictors}{A list object identifying additional predictors and 
their pre-treatment years and operators.}

\item{treated.units}{A vector identifying the \code{unit.variable} numbers of 
the treated units.}

\item{control.units}{A vector identifying the \code{unit.variable} numbers of 
the control units.}

\item{time.predictors.prior}{A numeric vector identifying the pretreatment 
periods over which the values for the outcome predictors should be averaged.}

\item{time.optimize.ssr}{A numeric vector identifying the periods of the 
dependent variable over which the loss function should be minimized 
between each treated unit and its synthetic control.}

\item{unit.names.variable}{The column number or string with column name 
identifying the variable with units' names. The variable must be a character.}

\item{time.plot}{A vector identifying the periods over which results are 
to be plotted with \code{\link{path.plot}}}

\item{treatment.time}{A numeric value with the value in \code{time.variable}
that marks the intervention.}

\item{gen.placebos}{Logical. Whether a placebo (a synthetic control) 
for each unit in the donor pool should be constructed. Will increase 
computation time.}

\item{strategy}{The processing method you wish to use 
"sequential" or "multiprocess". Use "multiprocess" to parallelize operations
 and reduce computing time. Default is \code{sequential}.}

\item{Sigf.ipop}{The Precision setting for the ipop optimization routine. 
Default of 5.}
}
\value{
Data frame. Each column contains the outcome values for every 
time-point for one unit or its synthetic control. The last column contains 
the time-points.
}
\description{
Generates one synthetic control for each treated unit and calculates 
   the difference between the treated and the synthetic control for each. 
   Returns a vector with outcome values for the synthetic controls, 
   a plot of average treatment effects, and if required generates placebos 
   out of the donor pool to be used in conjunction with \code{\link{plac.dist}}. 
   All arguments are the same used for \code{\link[Synth]{dataprep}} in the \code{\link[Synth:synth]{Synth}}
   package, except for \code{treated.units}, \code{treatment.time}, and 
   \code{\link{generate.placebos}}.
}
\details{
The function runs \code{\link[Synth]{dataprep}} and \code{\link[Synth]{synth}} 
   for each unit identified in \code{treated.units}. It saves the vector with 
   predicted values for each synthetic control, to be used in estimating 
   average treatment effects in applications of Synthetic Controls for 
   multiple treated units.
   
   For further details on the arguments, see the documentation of 
   \code{\link[Synth:synth]{Synth}}.
}
\examples{
## Using the toy data from 'Synth':

library(Synth)
data(synth.data)
set.seed(42)

multi <- multiple.synth(foo = synth.data,
                       predictors = c("X1"),
                       predictors.op = "mean",
                       dependent = "Y",
                       unit.variable = "unit.num",
                       time.variable = "year",
                       treatment.time = 1990,
                       special.predictors = list(
                         list("Y", 1991, "mean")
                       ),
                       treated.units = c(2,7),
                       control.units = c(29, 13, 17),
                       time.predictors.prior = c(1984:1989),
                       time.optimize.ssr = c(1984:1990),
                       unit.names.variable = "name",
                       time.plot = 1984:1996, gen.placebos =  FALSE, 
                       Sigf.ipop = 2)
## Plot with the average path of the treated units and the average of their
## respective synthetic controls:

multi$p

}
