% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_FunctionalAnnotationPlot.R
\name{do_FunctionalAnnotationPlot}
\alias{do_FunctionalAnnotationPlot}
\title{Compute functional annotation plots using GO or KEGG ontologies}
\usage{
do_FunctionalAnnotationPlot(
  genes,
  org.db,
  organism = "hsa",
  database = "GO",
  GO_ontology = "BP",
  min.overlap = if (length(genes) <= 4) {
     1
 } else {
     3
 },
  p.adjust.cutoff = 0.05,
  pAdjustMethod = "BH",
  minGSSize = 10,
  maxGSSize = 500,
  cluster_cols = TRUE,
  cluster_rows = TRUE,
  cell_size = 8,
  heatmap_gap = 0.5,
  font.size = 10,
  font.type = "sans",
  rotate_x_axis_labels = 45,
  xlab = NULL,
  ylab = NULL,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  plot.grid = TRUE,
  grid.color = "grey75",
  grid.type = "dashed",
  flip = TRUE,
  legend.type = "colorbar",
  legend.position = "bottom",
  legend.framewidth = 0.5,
  legend.tickwidth = 0.5,
  legend.length = 20,
  legend.width = 1,
  legend.framecolor = "grey50",
  legend.tickcolor = "white",
  heatmap.legend.length = 75,
  heatmap.legend.width = 5,
  heatmap.legend.framecolor = "black",
  viridis_color_map = "G",
  viridis_direction = -1,
  showCategory = 30,
  nWords = 4,
  nCluster = 5
)
}
\arguments{
\item{genes}{\strong{\code{\link[base]{character}}} | Vector of gene symbols to query for functional annotation.}

\item{org.db}{\strong{\code{OrgDB}} | Database object to use for the query.}

\item{organism}{\strong{\code{\link[base]{character}}} | Supported KEGG organism.}

\item{database}{\strong{\code{\link[base]{character}}} | Database to run the analysis on. One of:
\itemize{
\item \emph{\code{GO}}.
\item \emph{\code{KEGG}}.
}}

\item{GO_ontology}{\strong{\code{\link[base]{character}}} | GO ontology to use. One of:
\itemize{
\item \emph{\code{BP}}: For \strong{B}iological \strong{P}rocess.
\item \emph{\code{MF}}: For \strong{M}olecular \strong{F}unction.
\item \emph{\code{CC}}: For \strong{C}ellular \strong{C}omponent.
}}

\item{min.overlap}{\strong{\code{\link[base]{numeric}}} | Filter the output result to the terms which are supported by this many genes.}

\item{p.adjust.cutoff}{\strong{\code{\link[base]{numeric}}} | Significance cutoff used to filter non-significant terms.}

\item{pAdjustMethod}{\strong{\code{\link[base]{character}}} | Method to adjust for multiple testing.  One of:
\itemize{
\item \emph{\code{holm}}.
\item \emph{\code{hochberg}}.
\item \emph{\code{hommel}}.
\item \emph{\code{bonferroni}}.
\item \emph{\code{BH}}.
\item \emph{\code{BY}}.
\item \emph{\code{fdr}}.
\item \emph{\code{none}}.
}}

\item{minGSSize}{\strong{\code{\link[base]{numeric}}} | Minimal size of genes annotated by Ontology term for testing.}

\item{maxGSSize}{\strong{\code{\link[base]{numeric}}} | Maximal size of genes annotated for testing.}

\item{cluster_cols}{\strong{\code{\link[base]{logical}}} | Cluster the columns or rows of the heatmaps.}

\item{cluster_rows}{\strong{\code{\link[base]{logical}}} | Cluster the rows or rows of the heatmaps.}

\item{cell_size}{\strong{\code{\link[base]{numeric}}} | Size of each cell in the heatmap.}

\item{heatmap_gap}{\strong{\code{\link[base]{numeric}}} | Gap in cm between heatmaps.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{rotate_x_axis_labels}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the panels.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{legend.type}{\strong{\code{\link[base]{character}}} | Type of legend to display. One of:
\itemize{
\item \emph{\code{normal}}: Default legend displayed by \pkg{ggplot2}.
\item \emph{\code{colorbar}}: Redefined colorbar legend, using \link[ggplot2]{guide_colorbar}.
\item \emph{\code{colorsteps}}: Redefined legend with colors going by range, in steps, using \link[ggplot2]{guide_colorsteps}.
}}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.framewidth, legend.tickwidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines of the box in the legend.}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}

\item{legend.tickcolor}{\strong{\code{\link[base]{character}}} | Color of the ticks of the box in the legend.}

\item{heatmap.legend.length, heatmap.legend.width}{\strong{\code{\link[base]{numeric}}} | Width and length of the legend in the heatmap.}

\item{heatmap.legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the edges and ticks of the legend in the heatmap.}

\item{viridis_color_map}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis_direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{showCategory}{\strong{\code{\link[base]{numeric}}} | Number of enriched terms to display in the output tree plot.}

\item{nWords}{\strong{\code{\link[base]{numeric}}} | The number of words in the cluster tags in the tree plot.}

\item{nCluster}{\strong{\code{\link[base]{numeric}}} | The number of clusters to group the resulting terms in the tree plot. Suggested value is above 2, as two can lead to some errors.}
}
\value{
A list containing a heatmap of the presence/absence of the genes in the enriched term, as well as a bar plot, dot plot and tree plot of the enriched terms.
}
\description{
Compute functional annotation plots using GO or KEGG ontologies
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_FunctionalAnnotationPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Need to load this library or equivalent.
    suppressMessages(library("org.Hs.eg.db"))

    # Define list of genes to query.
    genes.use <- c("CCR7", "CD14", "LYZ",
                   "S100A4", "MS4A1",
                   "MS4A7", "GNLY", "NKG7", "FCER1A",
                   "CST3", "PPBP")

    # Compute the grouped GO terms.
    out <- SCpubr::do_FunctionalAnnotationPlot(genes = genes.use,
                                               org.db = org.Hs.eg.db)

  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
