% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EOQ.R
\name{EOQ}
\alias{EOQ}
\title{Economic Order Quantity model}
\usage{
EOQ(d, k, h, b = 0)
}
\arguments{
\item{d}{Demand per unit time.}

\item{k}{Ordering or fixed cost per order.}

\item{h}{Holding cost per unit of product.}

\item{b}{Shortage penalty cost per unit (default:0)}
}
\value{
A list containing:
\item{T}{Time between orders (cycle length)}
\item{S}{Maximum backorders in units. Displayed when b > 0}
\item{TVC}{Total variable cost.}
}
\description{
This function finds the optimal order policy in the classical Economic Order Quantity (EOQ) model and the EOQ model with planned shortages.
}
\details{
The EOQ model, also called Lot-Sizing model, considers that demand is uniform
and deterministic. Lead time, the time between the placement of an order and its receipt, is equal to zero.

The optimal order policy in the classical EOQ model minimizes the total cost associated with the ordering
and holding costs while meeting all demand (without shortage). When shortages are allowed (\eqn{b>0})
we have the EOQ model with backorders or planned shortages.
}
\examples{
 \dontrun{
#Classical EOQ model
#Given demand d=8000 items per year; set up cost k=12000; and holding cost h=0.3
#per unit we find that the optimal solution is to order 25298 units every 3.2
#months with a total variable cost of $7589.5}
 
EOQ(8000,12000,0.3)

\dontrun{
#EOQ model with planned shortages
#Consider now that backorders are allowed with a backorder cost b=1.1 per
#unit and year. Then the optimal solution is to order 28540 units every 3.6 months.
#The total variable cost is $6727.3 and the maximum shortage is 6116 units.}
   
EOQ(8000,12000,0.3,1.1)


}
\references{
- Hillier, F. and Lieberman, G. (2001). \emph{Introduction to operational research}.
  New York: McGraw-Hill, 7th.
}
\seealso{
EPQ, newsboy, WW
}
