% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cobraInit.R
\name{cobraInit}
\alias{cobraInit}
\title{Initial phase for COBRA optimizer}
\usage{
cobraInit(xStart, fn, fName, lower, upper, nConstraints, feval,
  initDesign = "RANDOM", initDesPoints = 2 * length(xStart) + 1,
  initDesOptP = NULL, initBias = 0.005, seqOptimizer = "COBYLA",
  seqFeval = 1000, seqTol = 1e-06, penaF = c(3, 1.7, 3e+05),
  squaresF = TRUE, squaresC = TRUE, conTol = 0,
  constraintHandling = "DEFAULT", sigmaD = c(3, 2, 100),
  repairInfeas = FALSE, repairMargin = NULL, ri = defaultRI(),
  DOSAC = 1, sac = defaultSAC(DOSAC), epsilonInit = NULL,
  epsilonMax = NULL, solu = NULL, saveIntermediate = FALSE,
  saveSurrogates = FALSE, RBFmodel = "cubic", RBFwidth = -1,
  GaussRule = "One", RBFrho = 0, skipPhaseI = TRUE,
  trueFuncForSurrogates = FALSE, drFactor = 1, XI = DRCL,
  rescale = TRUE, newlower = -1, newupper = 1, DEBUG_XI = FALSE,
  SKIP_HIGH = FALSE, DEBUG_RBF = FALSE, TrustRegion = FALSE,
  TRlist = defaultTR(), verbose = 1, verboseIter = 10, cobraSeed)
}
\arguments{
\item{xStart}{a vector containing the starting point for the optimization problem}

\item{fn}{objective function that is to be minimized, should return a vector of the
                     objective function value and the constraint values}

\item{fName}{file name .Rdata where the results of \code{\link{cobraPhaseII}} are saved}

\item{lower}{lower bound of search space, same dimension as \code{xStart}}

\item{upper}{upper bound of search space, same dimension as \code{xStart}}

\item{nConstraints}{number of constraints}

\item{feval}{maximum number of function evaluations}

\item{initDesign}{["RANDOM"] one out of ["RANDOM","LHS","BIASED","OPTIMIZED","OPTBIASED"]}

\item{initDesPoints}{number of initial points, must be smaller than feval}

\item{initDesOptP}{[NULL] only for initDesign=="OPTBIASED": number of points for the "OPT"
                     phase. If NULL, take initDesPoints.}

\item{initBias}{[0.005] bias for normal distribution in "OPTBIASED" and "BIASED"}

\item{seqOptimizer}{["COBYLA"] string defining the optimization method for COBRA phases I
                     and II, one out of ["COBYLA","ISRES","HJKB","NMKB","ISRESCOBY"]}

\item{seqFeval}{maximum number of function evaluations on the surrogate model}

\item{seqTol}{[1e-6] Convergence tolerance, see param \code{tol} in \code{\link[dfoptim]{nmkb}}}

\item{penaF}{[c(3,1.7,3e5)] parameters for dynamic penalty factor (fct subProb in cobraPhaseII): \code{c(start,augment,max)}}

\item{squaresF}{[FALSE] set to TRUE for \code{fitnessSurrogate <- trainCubicRBF(..., squares=T)}}

\item{squaresC}{[FALSE] set to TRUE for \code{constraintSurrogates <- trainCubicRBF(..., squares=T)}}

\item{conTol}{[0.0] constraint violation tolerance}

\item{constraintHandling}{["DEFAULT"] (other choices: "JOINESHOUCK", "SMITHTATE", "COIT", "BAECKKHURI";
                     experimental, only for penalty-based internal optimizers NMKB or HJKB,
                     see the code in function \code{subProb} in \code{\link{cobraPhaseII}})}

\item{sigmaD}{[c(3,2.0,100)] parameters for dynamic distance factor (fct subProb in cobraPhaseII): \code{c(start,augment,max)}}

\item{repairInfeas}{[FALSE] if TRUE, try to repair infeasible solutions}

\item{repairMargin}{-- deprecated --}

\item{ri}{[\code{\link{defaultRI}()}] list with other parameters for
                     \code{\link{repairInfeasRI2}}}

\item{DOSAC}{[0|1|2] if >0, any elements of \code{sac} not set by the user are set to \code{defaultSAC(DOSAC)}.
                     0: COBRA-R settings, 1: SACOBRA settings, 2: SACOBRA settings with fewer parameters
                     and more online adujustement (aFF and aCF are done parameter free).}

\item{sac}{[\code{\link{defaultSAC}(DOSAC)}] list with other parameters for SACOBRA}

\item{epsilonInit}{initial constant added to each constraint to maintain a certain margin to boundary}

\item{epsilonMax}{maximum for constant added to each constraint}

\item{solu}{[NULL] the best-known solution (only for diagnostics). This is normally a
                     vector of length d. If there are multiple solutions, it is a matrix with d
                     columns (each row is a solution). If NULL, then the current best point
                     will be used in \code{\link{cobraPhaseII}}.
                     \code{solu} is given in original input space.}

\item{saveIntermediate}{[FALSE] if TRUE, then cobraPhaseI + II save intermediate results
                     in dir 'results/' (create it, if necessary)}

\item{saveSurrogates}{[FALSE] if TRUE, then cobraPhaseII returns the last surrogate models in
                     cobra$fitnessSurrogate and cobra$constraintSurrogates}

\item{RBFmodel}{["cubic"] a string assigning type of the RBF model, "cubic" or "Gaussian"}

\item{RBFwidth}{[-1] only relevant for Gaussian RBF model, see \code{\link{trainGaussRBF}}}

\item{GaussRule}{["One"] only relevant for Gaussian RBF model, see \code{\link{trainGaussRBF}}}

\item{RBFrho}{[0.0] experimental: 0: interpolating, >0, approximating (spline-like) Gaussian RBFs}

\item{skipPhaseI}{[FALSE] if TRUE, then skip \code{\link{cobraPhaseI}}}

\item{trueFuncForSurrogates}{[FALSE] if TRUE, use the true (constraint & fitness) functions
                     instead of surrogates (only for debug analysis)}

\item{drFactor}{[1.0] factor multiplied to the DR-constraint (gCOBRA)}

\item{XI}{magic parameters for the distance requirement (DR)}

\item{rescale}{[TRUE] if TRUE change \code{[lower,upper]} to hypercube \code{[newlower,newupper]^d}}

\item{newlower}{[-1] lower bound of each rescaled input space dimension, if rescale==TRUE}

\item{newupper}{[+1] upper bound of each rescaled input space dimension, if rescale==TRUE}

\item{DEBUG_XI}{[FALSE] if TRUE, then print in cobraPhaseII extra debug information:
                     xStart in every iteration to console and add some extra debug
                     columns to cobra$df}

\item{SKIP_HIGH}{[FALSE] (deprecated) if TRUE, then build the surrogate models in cobraPhaseII by
                     skipping the data points having Fres (objective function) in the highest decile.}

\item{DEBUG_RBF}{[FALSE] visualize RBF (only for dimension==2)}

\item{TrustRegion}{[FALSE] if TRUE, an embedded  trust region algorithm \code{\link{trustRegion}} is performed.}

\item{TRlist}{[\code{\link{defaultTR}()}] a list of parameters, needed only
                     in case \code{TrustRegion==TRUE}.}

\item{verbose}{[1] one out of [0|1|2], how much output to print}

\item{verboseIter}{[10]}

\item{cobraSeed}{seed for random number generator}
}
\value{
\code{cobra}, an object of class COBRA, this is a (long) list containing most
  of the argument settings (see above) and in addition (among others)
     \item{\code{A}}{ (feval x dim)-matrix containing the initial design points in input .
           space. If rescale==TRUE, all points are in  \strong{rescaled} input space. }
     \item{\code{Fres}}{ a vector of the objective values of the initial design points }
     \item{\code{Gres}}{ a matrix of the constraint values of the initial design points }
     \item{\code{Tfeas}}{ the threshhold parameter for the number of consecutive iterations
           that yield feasible solutions before margin epsilon is reduced }
     \item{\code{Tinfeas}}{ the threshhold parameter for the number of consecutive iterations
           that yield infeasible solutions before margin epsilon is increased }
     \item{\code{numViol}}{ number of constraint violations }
     \item{\code{maxViol}}{ maximum constraint violation }
     \item{\code{refinedX}}{A vector of all refined solutions generated by trust region algorithm (see \code{trustRegion})}

  Note that \code{cobra$Fres}, \code{cobra$fbest}, \code{cobra$fbestArray} and similar contain
  always the objective values of the orignial function \code{cobra$fn[1]}. (The surrogate models
  may be trained on a \code{\link{plog}}-transformed version of this function.)
}
\description{
Constraint-based optimization initialization
}
\details{
If \code{epsilonInit} or \code{epsilonMax} are NULL on input, then \code{cobra$epsilonInit}
  and \code{cobra$epsilonMax},  resp., are set to \code{0.005*l} where \code{l} is the smallest
  side of the search box.\cr
  Note that the parameters \code{penaF}, \code{sigmaD}, \code{constraintHandling} are only
  relevant for penalty-based internal optimizers NMKB or HJKB.
}
\author{
Wolfgang Konen, Samineh Bagheri, Patrick Koch, Cologne Univeristy of Applied Sciences
}
\seealso{
\code{\link{startCobra}}, \code{\link{cobraPhaseI}}, \code{\link{cobraPhaseII}}
}

