% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_path.R
\name{plot_path}
\alias{plot_path}
\title{Plot a path.}
\usage{
plot_path(
  metrics,
  title = NULL,
  quadrants = FALSE,
  highlight.interpolated = TRUE,
  highlight.initial = TRUE,
  margins = c(0, 2, 4, 2),
  ...
)
}
\arguments{
\item{metrics}{A \code{metrics} object from \code{\link{calculate_metrics}}.}

\item{title}{An optional title for the plot. The default is to use the path
name saved in the \code{metrics} object.}

\item{quadrants}{Should the quadrants be marked on the plot. Default is FALSE}

\item{highlight.interpolated}{Should interpolated sections of the path be
highlighted (in grey). Default is TRUE.}

\item{highlight.initial}{Should the initial section of the path be
highlighted (in red). Default is TRUE. This is the section of the path
equivalent in length to the distance between the start and the goal.}

\item{margins}{The margins of the plot (see the option \code{mar} in
\code{\link[graphics]{par}}). The defaults should normally not need to be
changed.}

\item{...}{Additional arguments passed to the plot method in the
\code{\link[sp]{SpatialPolygons-class}} to modify plot details.}
}
\description{
Plots the path together with a representation of the arena. These plots are
useful for diagnosis of classification problems.
}
\details{
The path is plotted together with the context of the arena. The three
concentric zones of the arena (the wall, outer wall and annulus) are drawn in
progressively lighter shades of blue. The goal is a filled circle in orange
and the old goal is drawn in grey. The direct path to goal is shown as a
broken orange line and the 'approach corridor' (in transparent orange) is
defined as a triangle fanning out from this line by 20 degrees either side.
The path itself is drawn in black with grey sections corresponding to
interpolated data (if \code{highlight.interpolated = TRUE}, the parameter
\code{interpolate = TRUE} was set in \code{\link{read_path}} and there were
missing data points in the raw track file). The initial path (the section of
the path equivalent in length to the distance between the start and the goal)
is drawn in red if \code{highlight.initial = TRUE}.
}
\examples{
require(Rtrack)
track_file <- system.file("extdata", "Track_1.csv", package = "Rtrack")
arena_description <- system.file("extdata", "Arena_SW.txt", package = "Rtrack")
arena <- read_arena(arena_description)
path <- read_path(track_file, arena, track.format = "ethovision.3.csv")
metrics <- calculate_metrics(path, arena)
plot_path(metrics)

}
\seealso{
\code{\link{calculate_metrics}}, and also
  \code{\link{read_experiment}} for processing many tracks at once.
}
