\name{newArgs}
\alias{newArgs}
\alias{changeArgs}
\alias{changeArgs.pars}
\title{Create or modify a sampletrees settings object}
\description{
Create or modify a settings object containing the arguments
for a run of the C++ program sampletrees. 
}
\details{
 	
The function newArgs() initializes a list object of class `pars' that contains the 
settings for a run of sampletrees. 
The user can optionally pass arguments to newArgs to change some of the
settings from their default values.  The format for passing arguments to 
newArgs is: TagName=Value. The allowable tag 
names and their default values for an object of type 'pars' are given below in the 
Value section.

The function changeArgs modifies the values in a settings object of class `pars'. The arguments are passed to changeArgs in same way as to newArgs. 

Note that although both functions allow list elements to be 
set to default values, before running sampletrees the user will
have to provide non-default values for some elements (DataFile, 
LocationFile, WeightFile, FocalPoint). Using non-default 
values is recommended for ChainLength/BurnIn/Thinning as the
default values are set to ensure short test runs. 
}
\usage{
newArgs(...)

\method{changeArgs}{pars}(object,...)
}
\arguments{
\item{object}{An object of class `pars'}
\item{\ldots}{Tags and the values they should be set to. A list of the tag names is given in the Value section}
}
\value{
Returns an object of class `pars' which is a list with elements:
\item{RunName}{Run name for the sampletrees run (Default="Run")} 
\item{Seed}{Initial seed for sampletrees run. (Default=NA)} 
\item{DataType}{The type of the data file g=genotype h=haplotype. (Default="h")}
\item{DataFile}{The name of the file containing the haplotype or genotype data. DEFAULT=NA
but the user must change this value before running sampletrees} 
\item{LocationFile}{The name of the file containing the genomic locations (in base pairs) 
of the SNP markers. Default=NA but the user must change this value before running sampletrees}
\item{WeightFile}{The name of the file containing the probabilities for sampling each of the 7 
updates. Default=NA but the user must change this value before running sampletrees. See setWeights for more information.}
\item{FocalPoint}{The location of the focal point. Default=NA but the user must change this value before running sampletrees} 
\item{ChainLength}{How long to run the chain. (Default=1000)} 
\item{BurnIn}{Discard the first 'BurnIn' samples. (Default=100)}
\item{Thinning}{Return output every 'Thinning'th sample. (Default=1)}
\item{InitialTheta}{Initial value for mutation rate theta. (Default=1)}
\item{MinTheta}{Minimum for Uniform prior for theta. (Default=0.0001)}
\item{MaxTheta}{Maximum for Univorm prior for theta. (Default=10)}
\item{InitialRho}{Initial value for recombination rate rho. (Default=0.0004)}
\item{ScaleRho}{Scale parameter for gamma prior for rho. (Default=0.1)}
\item{ShapeRho}{Shape parameter for gamma prior for rho. (Default=1)}
\item{InitialTreeFile}{Name for a file containing initial tree data for a run of
sampletrees. These are typically available from a previous run of sampletrees. 
If DataType="g", initial haplotype configurations will be taken from this file
rather than one specified by InitialHaploFile. (Default=NA)}
\item{RandomTree}{Indicates whether initial tree generated by randomly connecting
nodes. (Default=FALSE)}
\item{HaploFreqFile}{The name of the file with the haplo frequency estimates to be 
used only if DataType="g". See estimateHapFreqs() for more information. Default=NA 
but user must change this value if DataType is 'g'.} 
\item{InitialHaploFile}{Name for an optional file containing
the initial haplotype configurations for the sampletrees run (optional if DataType="g"). 
Each row of this file corresponds to a haplotype, there are 2 rows/individual 
and rows must be 
in the same order as in DataFile. (Default=NA)}  
\item{HaploListFile}{Name for a optional file containing
a list of likely haplotypes (optional if DataType="g"). Each row corresponds to a haplotype. 
(Default=NA)} 
\item{clean}{An indicator for whether the list passes the checks for a 
clean sampletrees run. In order to ensure no errors with sampletrees, 
the user should not modify this value and instead should run checkPars().
(Default=FALSE)}
}
\examples{
runpars=newArgs(DataFile="sequences_Theta8_Rho8.txt", DataType="h", 
		LocationFile="locations_Theta8_Rho8.txt",RunName="Test-h",FocalPoint=10000)
runpars=changeArgs(runpars, Seed=1938474, WeightFile="weights-h.txt")
}
\references{TBD}
\author{Kelly Burkett}
\seealso{checkArgs}