% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tile_geoprocessor}
\alias{tile_geoprocessor}
\title{Split a raster grid into tiles for tile-based processing}
\usage{
tile_geoprocessor(x, grid, nx, ny, overlap = 0, file_path = NULL)
}
\arguments{
\item{x}{saga S3 object}

\item{grid}{character, or RasterLayer. GDAL-supported raster as as a path to
the raster or representing a RasterLayer object}

\item{nx}{numeric, number of x-pixels per tile}

\item{ny}{numeric, number of y-pixels per tile}

\item{overlap}{numeric, number of overlapping pixels}

\item{file_path}{character, optional file path to store raster tiles}
}
\value{
list of RasterLayer objects representing tiled data
}
\description{
Split a raster grid into tiles. The tiles are saved as Rsagacmd
temporary files, and are loaded as a list of R objects for futher
processing. This is a function to make the the SAGA-GIS
grid_tools / tiling tool more convenient to use.
}
\examples{
\dontrun{
# Initialize a saga object
saga <- saga_gis()

# Generate a random DEM
dem <- saga$grid_calculus$random_terrain(radius = 15, iterations = 500)

# Return tiled version of DEM
tiles <- tile_geoprocessor(x = saga, grid = dem, nx = 20, ny = 20)
}
}
