% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyhedra-lib.R
\docType{class}
\name{PolyhedronStateNetlibScraper}
\alias{PolyhedronStateNetlibScraper}
\title{PolyhedronStateNetlibScraper}
\description{
Scrapes polyhedra from a PHD file format.
}
\author{
ken4rab
}
\section{Super class}{
\code{\link[Rpolyhedra:PolyhedronState]{Rpolyhedra::PolyhedronState}} -> \code{PolyhedronStateNetlibScraper}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{netlib.p3.lines}}{The path to the PHD files}

\item{\code{labels.rows}}{Labels - row of appearance}

\item{\code{labels.map}}{Labels - Map of content}

\item{\code{errors}}{the errors found}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PolyhedronStateNetlibScraper-new}{\code{PolyhedronStateNetlibScraper$new()}}
\item \href{#method-PolyhedronStateNetlibScraper-extractRowsFromLabel}{\code{PolyhedronStateNetlibScraper$extractRowsFromLabel()}}
\item \href{#method-PolyhedronStateNetlibScraper-getLabels}{\code{PolyhedronStateNetlibScraper$getLabels()}}
\item \href{#method-PolyhedronStateNetlibScraper-scrapeNet}{\code{PolyhedronStateNetlibScraper$scrapeNet()}}
\item \href{#method-PolyhedronStateNetlibScraper-extractCFOutBrackets}{\code{PolyhedronStateNetlibScraper$extractCFOutBrackets()}}
\item \href{#method-PolyhedronStateNetlibScraper-scrapeVertices}{\code{PolyhedronStateNetlibScraper$scrapeVertices()}}
\item \href{#method-PolyhedronStateNetlibScraper-setupLabelsOrder}{\code{PolyhedronStateNetlibScraper$setupLabelsOrder()}}
\item \href{#method-PolyhedronStateNetlibScraper-getDataFromLabel}{\code{PolyhedronStateNetlibScraper$getDataFromLabel()}}
\item \href{#method-PolyhedronStateNetlibScraper-getName}{\code{PolyhedronStateNetlibScraper$getName()}}
\item \href{#method-PolyhedronStateNetlibScraper-scrape}{\code{PolyhedronStateNetlibScraper$scrape()}}
\item \href{#method-PolyhedronStateNetlibScraper-applyTransformationMatrix}{\code{PolyhedronStateNetlibScraper$applyTransformationMatrix()}}
\item \href{#method-PolyhedronStateNetlibScraper-buildRGL}{\code{PolyhedronStateNetlibScraper$buildRGL()}}
\item \href{#method-PolyhedronStateNetlibScraper-exportToXML}{\code{PolyhedronStateNetlibScraper$exportToXML()}}
\item \href{#method-PolyhedronStateNetlibScraper-clone}{\code{PolyhedronStateNetlibScraper$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="Rpolyhedra" data-topic="PolyhedronState" data-id="addError"><a href='../../Rpolyhedra/html/PolyhedronState.html#method-PolyhedronState-addError'><code>Rpolyhedra::PolyhedronState$addError()</code></a></span></li>
<li><span class="pkg-link" data-pkg="Rpolyhedra" data-topic="PolyhedronState" data-id="checkEdgesConsistency"><a href='../../Rpolyhedra/html/PolyhedronState.html#method-PolyhedronState-checkEdgesConsistency'><code>Rpolyhedra::PolyhedronState$checkEdgesConsistency()</code></a></span></li>
<li><span class="pkg-link" data-pkg="Rpolyhedra" data-topic="PolyhedronState" data-id="getSolid"><a href='../../Rpolyhedra/html/PolyhedronState.html#method-PolyhedronState-getSolid'><code>Rpolyhedra::PolyhedronState$getSolid()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-new"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-new}{}}}
\subsection{Method \code{new()}}{
Initializes the object, taking the file.id and PDH file as parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$new(file.id, netlib.p3.lines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file.id}}{the file id}

\item{\code{netlib.p3.lines}}{the lines to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new  PolyhedronStateNetlibScraper object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-extractRowsFromLabel"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-extractRowsFromLabel}{}}}
\subsection{Method \code{extractRowsFromLabel()}}{
Extracts data from the label, taking the label number and the
  expected label as parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$extractRowsFromLabel(label.number, expected.label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label.number}}{the label number}

\item{\code{expected.label}}{the expected label}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-getLabels"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-getLabels}{}}}
\subsection{Method \code{getLabels()}}{
get Labels from current netlib file description
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$getLabels()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list containing labels from netlib file description
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-scrapeNet"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-scrapeNet}{}}}
\subsection{Method \code{scrapeNet()}}{
scrape Net Model from netlib format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$scrapeNet(net.txt, offset = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{net.txt}}{a vector containing net model in netlib format}

\item{\code{offset}}{in numbering vertices}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list containing a net model
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-extractCFOutBrackets"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-extractCFOutBrackets}{}}}
\subsection{Method \code{extractCFOutBrackets()}}{
Remove brackets for current field content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$extractCFOutBrackets(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a string containing brackets}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-scrapeVertices"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-scrapeVertices}{}}}
\subsection{Method \code{scrapeVertices()}}{
scrape vertices described in netlib format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$scrapeVertices(vertices.txt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vertices.txt}}{vector containing netlib format vertices}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.frame containing netlib vertices
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-setupLabelsOrder"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-setupLabelsOrder}{}}}
\subsection{Method \code{setupLabelsOrder()}}{
setupLabelsOrder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$setupLabelsOrder()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vertices.txt}}{vector containing netlib format vertices}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.frame containing netlib vertices
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-getDataFromLabel"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-getDataFromLabel}{}}}
\subsection{Method \code{getDataFromLabel()}}{
Get data from label specified as parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$getDataFromLabel(label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{the label to get data from}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-getName"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-getName}{}}}
\subsection{Method \code{getName()}}{
get Polyhedron name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string with polyhedron name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-scrape"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-scrape}{}}}
\subsection{Method \code{scrape()}}{
scrape Netlib polyhedron definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$scrape()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new PolyhedronStateDefined object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-applyTransformationMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-applyTransformationMatrix}{}}}
\subsection{Method \code{applyTransformationMatrix()}}{
Apply transformation matrix to polyhedron
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$applyTransformationMatrix(transformation.matrix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformation.matrix}}{the transformation matrix to apply to the polyhedron}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-buildRGL"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-buildRGL}{}}}
\subsection{Method \code{buildRGL()}}{
Creates a 'rgl' representation of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$buildRGL(transformation.matrix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformation.matrix}}{the transformation matrix to apply to the polyhedron}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-exportToXML"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-exportToXML}{}}}
\subsection{Method \code{exportToXML()}}{
serializes object in XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$exportToXML()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PolyhedronStateNetlibScraper-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PolyhedronStateNetlibScraper-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedronStateNetlibScraper$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
