% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roles.add.settings.R
\name{roles.add.settings}
\alias{roles.add.settings}
\title{Add or update role setting}
\usage{
roles.add.settings(id, value, api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the role This field has the following domains: (deal_default_visibility; org_default_visibility; person_default_visibility; product_default_visibility; deal_access_level; org_access_level; person_access_level; product_access_level)}

\item{value}{Possible values for default_visibility settings: 0...1; for access_level settings: 1...7 This field has the following domains: (0; 1; 2; 3; 4; 5; 6; 7)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Add or update role setting on pipedrive.
}
\examples{
\donttest{
roles.add.settings(id='e.g.',value='e.g.',api_token='token',company_domain='exp')
}
}
