% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyz2abc.R
\name{xyz2abc}
\alias{abc2xyz}
\alias{abc2xyz.atoms}
\alias{abc2xyz.coords}
\alias{abc2xyz.distances}
\alias{abc2xyz.pdb}
\alias{xyz2abc}
\alias{xyz2abc.atoms}
\alias{xyz2abc.coords}
\alias{xyz2abc.distances}
\alias{xyz2abc.pdb}
\title{From Cartesian to Fractional Coordinates and Vis Versa}
\usage{
xyz2abc(...)

\method{xyz2abc}{coords}(x, cryst1, ...)

\method{xyz2abc}{atoms}(x, cryst1, ...)

\method{xyz2abc}{pdb}(x, cryst1 = x$cryst1, ...)

\method{xyz2abc}{distances}(x, cryst1, ...)

abc2xyz(...)

\method{abc2xyz}{coords}(x, cryst1, ...)

\method{abc2xyz}{atoms}(x, cryst1, ...)

\method{abc2xyz}{pdb}(x, cryst1 = x$cryst1, ...)

\method{abc2xyz}{distances}(x, cryst1, ...)
}
\arguments{
\item{x}{an R object containing atomic coordinates.}

\item{cryst1}{an object of class \code{\link{cryst1}}.}

\item{\dots}{arguments passed to methods.}
}
\value{
Return an object of the same class as \code{x}, with atomic 
  coordinates expressed in a different basis set.
}
\description{
Converts Cartesian coordinates into fractional coordinates and vice versa.
}
\details{
For \code{\link{atoms}} and \code{\link{pdb}} objects, the atomic coordinates
are first extracted from \code{x} using the \code{\link{coords}} function. 
Then, using the periodic boundary conditions stored into \code{cryst1}, the 
coordinates are converted from Cartesian to fractional (for the 
\code{xyz2abc} functions) or from fractional to Cartesian (for the 
\code{abc2xyz} functions) coordinates. Finally, for \code{\link{atoms}} and 
\code{\link{pdb}} objects, the new atomic coordinates are reassigned to the 
original \code{x} object using the \code{\link{coords<-}} function and 
\code{x} is returned.
}
\examples{
x <- read.pdb(system.file("examples/PCBM_ODCB.pdb",package="Rpdb"))
basis(x)
x <- xyz2abc(x)
basis(x)
x <- abc2xyz(x)
basis(x)

\dontrun{
  
  # This example return an error because the coordinates stored
  # into the PDB file are already Cartesian coordinates.
  x <- read.pdb(system.file("examples/PCBM_ODCB.pdb",package="Rpdb"))
  x <- abc2xyz(x)
}

}
\seealso{
\code{\link{basis}}, \code{\link{coords}}, \code{\link{atoms}},
\code{\link{pdb}}, \code{\link{cryst1}}
}
\keyword{manip}

