\name{write.pdb}
\alias{write.pdb}
\title{
PDB File Writer
}
\description{
Writes a Protein Data Bank (PDB) coordinate file from an object of class \sQuote{pdb}.
}
\usage{
write.pdb(x, file = "Rpdb.pdb")
}
\arguments{
  \item{x}{an object, or a list of objects, of class \sQuote{pdb}.}
  \item{file}{a single element character vector containing the name of the PDB file to be created.}
}
\details{
All data stored in the \sQuote{pdb} object are written on a PDB file. A list of object of class \sQuote{pdb} can be provided to write multiple MODEL into a single file. In this case, each \sQuote{pdb} object of the list have to have the same \code{cryst1} and \code{conect} components.

To write only a subset of a \sQuote{pdb} object see function \code{\link{subset.pdb}}.
}
\references{
PDB format has been taken from:
http://www.wwpdb.org/documentation/format33/v3.3.html
}
\seealso{
\code{\link{read.pdb}}, \code{\link{pdb}}, \code{\link{cryst1}}, \code{\link{atoms}}, \code{\link{conect}}, \code{\link{subset.pdb}}
}
\examples{
## Read a PDB file included with the package
pdb <- read.pdb(system.file("examples/PCBM_ODCB.pdb",package="Rpdb"))

## Write the pdb object in file "Rpdb.pdb" into the current directory
write.pdb(pdb, file = "Rpdb.pdb")

}
\keyword{ IO }
