% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_metadata.R
\name{pdb_citations}
\alias{pdb_citations}
\alias{pdb_species_accepted}
\alias{pdb_species_author}
\alias{pdb_genus}
\alias{pdb_family}
\alias{pdb_order}
\alias{pdb_class}
\alias{pdb_phylum}
\alias{pdb_kingdom}
\alias{pdb_org_type}
\alias{pdb_dicot_monocot}
\alias{pdb_angio_gymon}
\alias{pdb_authors}
\alias{pdb_journal}
\alias{pdb_pub_year}
\alias{pdb_doi}
\alias{pdb_comments}
\alias{pdb_appendix_link}
\alias{pdb_duration}
\alias{pdb_start_year}
\alias{pdb_start_month}
\alias{pdb_end_year}
\alias{pdb_end_month}
\alias{pdb_periodicity}
\alias{pdb_population_name}
\alias{pdb_number_populations}
\alias{pdb_lat}
\alias{pdb_lon}
\alias{pdb_altitude}
\alias{pdb_country}
\alias{pdb_continent}
\alias{pdb_ecoregion}
\alias{pdb_studied_sex}
\alias{pdb_eviction_used}
\alias{pdb_evict_type}
\alias{pdb_treatment}
\alias{pdb_has_time_lag}
\alias{pdb_has_age}
\alias{pdb_report}
\title{Access pieces of metadata from a \code{pdb} object}
\usage{
pdb_citations(pdb, ipm_id = NULL)

pdb_species_accepted(pdb, ipm_id = NULL)

pdb_species_author(pdb, ipm_id = NULL)

pdb_genus(pdb, ipm_id = NULL)

pdb_family(pdb, ipm_id = NULL)

pdb_order(pdb, ipm_id = NULL)

pdb_class(pdb, ipm_id = NULL)

pdb_phylum(pdb, ipm_id = NULL)

pdb_kingdom(pdb, ipm_id = NULL)

pdb_org_type(pdb, ipm_id = NULL)

pdb_dicot_monocot(pdb, ipm_id = NULL)

pdb_angio_gymon(pdb, ipm_id = NULL)

pdb_authors(pdb, ipm_id = NULL)

pdb_journal(pdb, ipm_id = NULL)

pdb_pub_year(pdb, ipm_id = NULL)

pdb_doi(pdb, ipm_id = NULL)

pdb_comments(pdb, ipm_id = NULL)

pdb_appendix_link(pdb, ipm_id = NULL)

pdb_duration(pdb, ipm_id = NULL)

pdb_start_year(pdb, ipm_id = NULL)

pdb_start_month(pdb, ipm_id = NULL)

pdb_end_year(pdb, ipm_id = NULL)

pdb_end_month(pdb, ipm_id = NULL)

pdb_periodicity(pdb, ipm_id = NULL)

pdb_population_name(pdb, ipm_id = NULL)

pdb_number_populations(pdb, ipm_id = NULL)

pdb_lat(pdb, ipm_id = NULL)

pdb_lon(pdb, ipm_id = NULL)

pdb_altitude(pdb, ipm_id = NULL)

pdb_country(pdb, ipm_id = NULL)

pdb_continent(pdb, ipm_id = NULL)

pdb_ecoregion(pdb, ipm_id = NULL)

pdb_studied_sex(pdb, ipm_id = NULL)

pdb_eviction_used(pdb, ipm_id = NULL)

pdb_evict_type(pdb, ipm_id = NULL)

pdb_treatment(pdb, ipm_id = NULL)

pdb_has_time_lag(pdb, ipm_id = NULL)

pdb_has_age(pdb, ipm_id = NULL)

pdb_report(
  pdb,
  title = "",
  keep_rmd = TRUE,
  rmd_dest = getwd(),
  output_format = "html",
  render_output = TRUE,
  map = TRUE
)
}
\arguments{
\item{pdb}{A Padrino Database object.}

\item{ipm_id}{The ID of the model. The default (\code{NULL}) returns all
values in the \code{pdb} object.}

\item{title}{The title for the created report.}

\item{keep_rmd}{Keep the un-rendered Rmd file? Useful for manual editing.}

\item{rmd_dest}{The folder to save the Rmd file at if \code{keep_rmd = TRUE}.
The default is \code{getwd()}.}

\item{output_format}{The output format to create. Options are "html", "pdf",
"word", "odt", "rtf", or "md".}

\item{render_output}{A logical - should the document be rendered for inspection?}

\item{map}{Create a map of studies included in the \code{pdb} object?}
}
\value{
A vector of the metadata. For \code{pdb_report}e file path to the
rendered output, or to the \code{.rmd} file when \code{render_output = FALSE}.
}
\description{
These functions access pieces of specific pieces metadata from
the \code{Metadata} table of a \code{pdb} object. The exception is
\code{pdb_report}, which automatically generates a report with summary
statistics and citation information for the \code{pdb} object.
}
